/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.command;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.components.Models;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.LinkedList;
import java.util.Queue;
import net.neoforged.bus.api.SubscribeEvent;

public final class CommandHandler
extends Handler {
    private static final int TICKS_PER_EXECUTE = 7;
    private static final int NPC_DIALOGUE_WAIT_TICKS = 40;
    private final Queue<String> commandQueue = new LinkedList<String>();
    private int commandQueueTicks = 0;

    @SubscribeEvent
    public void onTick(TickEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (Models.NpcDialogue.isInDialogue()) {
            this.commandQueueTicks = 40;
            return;
        }
        --this.commandQueueTicks;
        if (this.commandQueueTicks <= 0 && !this.commandQueue.isEmpty()) {
            String command = this.commandQueue.poll();
            WynntilsMod.info("Executing queued command: " + command);
            McUtils.mc().getConnection().sendCommand(command);
            this.commandQueueTicks = 7;
        }
    }

    public void queueCommand(String command) {
        if (this.commandQueueTicks <= 0 && !Models.NpcDialogue.isInDialogue()) {
            WynntilsMod.info("Executing queued command immediately: " + command);
            McUtils.mc().getConnection().sendCommand(command);
            this.commandQueueTicks = 7;
        } else {
            this.commandQueue.add(command);
        }
    }

    public void sendCommandImmediately(String command) {
        WynntilsMod.info("Executing immediate command: " + command);
        McUtils.mc().getConnection().sendCommand(command);
    }
}

