/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.labels;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.event.EntityLabelEvent;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.event.LabelsRemovedEvent;
import com.wynntils.handlers.labels.event.TextDisplayChangedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.mc.event.SetEntityDataEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class LabelHandler
extends Handler {
    private final List<LabelParser> parsers = new ArrayList<LabelParser>();
    private final Map<Integer, LabelInfo> liveLabels = new HashMap<Integer, LabelInfo>();

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySetData(SetEntityDataEvent event) {
        this.handleTextDisplayEvents(event);
        this.handleEntityLabelEvents(event);
    }

    private void handleTextDisplayEvents(SetEntityDataEvent event) {
        Entity entity = McUtils.mc().level.getEntity(event.getId());
        if (!(entity instanceof Display.TextDisplay)) {
            return;
        }
        Display.TextDisplay textDisplay = (Display.TextDisplay)entity;
        for (SynchedEntityData.DataValue<?> packedItem : event.getPackedItems()) {
            StyledText newText;
            if (packedItem.id() != Display.TextDisplay.DATA_TEXT_ID.id()) continue;
            Component oldComponent = textDisplay.getText();
            Component newComponent = (Component)packedItem.value();
            StyledText oldText = StyledText.fromComponent(oldComponent);
            if (oldText.equals(newText = StyledText.fromComponent(newComponent))) continue;
            LabelInfo labelInfo = this.tryIdentifyLabel(newText, entity);
            if (labelInfo != null) {
                this.liveLabels.put(entity.getId(), labelInfo);
            }
            TextDisplayChangedEvent.Text textChangedEvent = new TextDisplayChangedEvent.Text(textDisplay, labelInfo, newText);
            WynntilsMod.postEvent(textChangedEvent);
            if (textChangedEvent.isCanceled()) {
                event.removePackedItem(packedItem);
                continue;
            }
            if (textChangedEvent.getText().equals(newText)) continue;
            SynchedEntityData.DataValue newTextData = new SynchedEntityData.DataValue(Display.TextDisplay.DATA_TEXT_ID.id(), packedItem.serializer(), (Object)textChangedEvent.getText().getComponent());
            event.removePackedItem(packedItem);
            event.addPackedItem(newTextData);
        }
    }

    private void handleEntityLabelEvents(SetEntityDataEvent event) {
        Entity entity = McUtils.mc().level.getEntity(event.getId());
        if (entity == null) {
            return;
        }
        for (SynchedEntityData.DataValue<?> packedItem : event.getPackedItems()) {
            Optional value;
            if (packedItem.id() == Entity.DATA_CUSTOM_NAME_VISIBLE.id()) {
                WynntilsMod.postEvent(new EntityLabelEvent.Visibility(entity, (Boolean)packedItem.value()));
                continue;
            }
            if (packedItem.id() != Entity.DATA_CUSTOM_NAME.id() || (value = (Optional)packedItem.value()).isEmpty()) continue;
            Component oldNameComponent = entity.getCustomName();
            StyledText oldName = oldNameComponent != null ? StyledText.fromComponent(oldNameComponent) : StyledText.EMPTY;
            StyledText newName = StyledText.fromComponent((Component)value.get());
            if (newName.equals(oldName)) continue;
            EntityLabelEvent.Changed labelChangedEvent = new EntityLabelEvent.Changed(entity, newName);
            WynntilsMod.postEvent(labelChangedEvent);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitiesRemoved(RemoveEntitiesEvent event) {
        List<LabelInfo> removedLabels = this.liveLabels.values().stream().filter(label -> event.getEntityIds().contains(label.getEntity().getId())).toList();
        removedLabels.forEach(label -> this.liveLabels.remove(label.getEntity().getId()));
        WynntilsMod.postEvent(new LabelsRemovedEvent(removedLabels));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        ArrayList<LabelInfo> oldLabels = new ArrayList<LabelInfo>(this.liveLabels.values());
        this.liveLabels.clear();
        WynntilsMod.postEvent(new LabelsRemovedEvent(oldLabels));
    }

    public void registerParser(LabelParser labelParser) {
        this.parsers.add(labelParser);
    }

    private LabelInfo tryIdentifyLabel(StyledText name, Entity entity) {
        for (LabelParser parser : this.parsers) {
            Object info = parser.getInfo(name, Location.containing((Position)entity.position()), entity);
            if (info == null) continue;
            WynntilsMod.postEvent(new LabelIdentifiedEvent((LabelInfo)info));
            return info;
        }
        return null;
    }
}

