/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.stats.StatCalculator;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatListDelimiter;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class TooltipIdentifications {
    public static List<Component> buildTooltip(IdentifiableItemProperty<?, ?> itemInfo, ClassType currentClass, TooltipIdentificationDecorator decorator, TooltipStyle style) {
        ArrayList<Component> identifications = new ArrayList<Component>();
        List<StatType> listOrdering = Models.Stat.getOrderingList(style.identificationOrdering());
        ArrayList<StatType> allStats = new ArrayList<StatType>(itemInfo.getVariableStats());
        itemInfo.getIdentifications().stream().map(StatActualValue::statType).filter(stat -> !allStats.contains(stat)).forEach(allStats::add);
        if (allStats.isEmpty()) {
            return identifications;
        }
        boolean useDelimiters = style.useDelimiters();
        boolean delimiterNeeded = false;
        for (StatType statType : listOrdering) {
            MutableComponent line;
            if (useDelimiters && statType instanceof StatListDelimiter && delimiterNeeded) {
                identifications.add((Component)Component.literal((String)""));
                delimiterNeeded = false;
            }
            if (!allStats.contains(statType) || (line = TooltipIdentifications.getStatLine(statType, itemInfo, currentClass, decorator, style)) == null) continue;
            identifications.add((Component)line);
            delimiterNeeded = true;
        }
        if (!identifications.isEmpty() && ((Component)identifications.getLast()).getString().isEmpty()) {
            identifications.removeLast();
        }
        return identifications;
    }

    private static MutableComponent getStatLine(StatType statType, IdentifiableItemProperty<?, ?> itemInfo, ClassType currentClass, TooltipIdentificationDecorator decorator, TooltipStyle style) {
        if (!itemInfo.getIdentifications().isEmpty()) {
            StatActualValue statActualValue = itemInfo.getIdentifications().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
            if (statActualValue == null) {
                WynntilsMod.warn("Missing value in item " + itemInfo.getName() + " for stat: " + String.valueOf(statType));
                return null;
            }
            MutableComponent line = TooltipIdentifications.buildIdentifiedLine(itemInfo, style, statActualValue, currentClass);
            StatPossibleValues possibleValues = itemInfo.getPossibleValues().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
            if (possibleValues == null) {
                WynntilsMod.warn("Missing stat type in item " + itemInfo.getName() + " for stat: " + String.valueOf(statType) + " which has value: " + statActualValue.value());
                return line;
            }
            if (possibleValues.range().isFixed() || decorator == null) {
                return line;
            }
            line.append((Component)decorator.getSuffix(statActualValue, possibleValues, style));
            return line;
        }
        StatPossibleValues possibleValues = itemInfo.getPossibleValues().stream().filter(stat -> stat.statType() == statType).findFirst().orElse(null);
        if (possibleValues == null) {
            WynntilsMod.warn("Missing possible values for stat type in item " + itemInfo.getName() + " for stat: " + String.valueOf(statType));
            return null;
        }
        return TooltipIdentifications.buildUnidentifiedLine(itemInfo, style, possibleValues);
    }

    private static MutableComponent buildIdentifiedLine(IdentifiableItemProperty itemInfo, TooltipStyle style, StatActualValue actualValue, ClassType currentClass) {
        StatType statType = actualValue.statType();
        int value = actualValue.value();
        int valueToShow = statType.calculateAsInverted() ? -value : value;
        boolean hasPositiveEffect = valueToShow > 0 ^ statType.displayAsInverted();
        String starString = style.showStars() ? "***".substring(3 - actualValue.stars()) : "";
        MutableComponent line = Component.literal((String)(StringUtils.toSignedString(valueToShow) + statType.getUnit().getDisplayName())).withStyle(Style.EMPTY.withColor(hasPositiveEffect ? ChatFormatting.GREEN : ChatFormatting.RED));
        if (!starString.isEmpty()) {
            line.append((Component)Component.literal((String)starString).withStyle(hasPositiveEffect ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
        }
        line.append((Component)Component.literal((String)(" " + Models.Stat.getDisplayName(statType, itemInfo.getRequiredClass(), currentClass, itemInfo.getIdentificationLevelRange()))).withStyle(ChatFormatting.GRAY));
        return line;
    }

    private static MutableComponent buildUnidentifiedLine(IdentifiableItemProperty itemInfo, TooltipStyle style, StatPossibleValues possibleValues) {
        StatType statType = possibleValues.statType();
        RangedValue valueRange = possibleValues.range();
        Pair<Integer, Integer> displayRange = StatCalculator.getDisplayRange(possibleValues, style.showBestValueLastAlways());
        boolean hasPositiveEffect = displayRange.a() > 0 ^ statType.displayAsInverted();
        ChatFormatting colorCode = hasPositiveEffect ? ChatFormatting.GREEN : ChatFormatting.RED;
        ChatFormatting colorCodeDark = hasPositiveEffect ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED;
        MutableComponent line = Component.literal((String)StringUtils.toSignedString(displayRange.a())).withStyle(colorCode);
        line.append((Component)Component.literal((String)" to ").withStyle(colorCodeDark));
        line.append((Component)Component.literal((String)(String.valueOf(displayRange.b()) + statType.getUnit().getDisplayName())).withStyle(colorCode));
        line.append((Component)Component.literal((String)(" " + Models.Stat.getDisplayName(statType, itemInfo.getRequiredClass(), Models.Character.getClassType(), itemInfo.getIdentificationLevelRange()))).withStyle(ChatFormatting.GRAY));
        return line;
    }
}

