/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.ConnectionEvent;
import com.wynntils.mc.event.PacketEvent;
import com.wynntils.utils.mc.McUtils;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
public abstract class ConnectionMixin {
    @Shadow
    private volatile PacketListener packetListener;

    @Unique
    private static boolean isRenderThread() {
        return McUtils.mc().isSameThread();
    }

    @WrapMethod(method={"channelRead0(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/protocol/Packet;)V"})
    private void channelRead0Pre(ChannelHandlerContext channelHandlerContext, Packet<?> packet, Operation<Void> original) {
        Packet<?> transformedPacket = ConnectionMixin.handleReceivePacket(packet);
        if (transformedPacket == null) {
            return;
        }
        original.call(new Object[]{channelHandlerContext, packet});
    }

    @Unique
    private static Packet<?> handleReceivePacket(Packet<?> packet) {
        if (packet instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = (ClientboundBundlePacket)packet;
            ArrayList<Packet> remainingPackets = new ArrayList<Packet>();
            boolean hasCancelled = false;
            for (Packet bundledPacket : bundlePacket.subPackets()) {
                PacketEvent.PacketSentEvent<Packet> bundledEvent = new PacketEvent.PacketSentEvent<Packet>(bundledPacket);
                MixinHelper.postAlways(bundledEvent);
                if (!bundledEvent.isCanceled()) {
                    remainingPackets.add(bundledPacket);
                    continue;
                }
                hasCancelled = true;
            }
            if (hasCancelled) {
                if (remainingPackets.isEmpty()) {
                    return null;
                }
                return new ClientboundBundlePacket(remainingPackets);
            }
        } else {
            PacketEvent.PacketReceivedEvent event = new PacketEvent.PacketReceivedEvent(packet);
            MixinHelper.postAlways(event);
            if (event.isCanceled()) {
                return null;
            }
        }
        return packet;
    }

    @Inject(method={"disconnect(Lnet/minecraft/network/DisconnectionDetails;)V"}, at={@At(value="RETURN")})
    private void disconnectPost(DisconnectionDetails disconnectionDetails, CallbackInfo ci) {
        String string;
        if (!(this.packetListener instanceof ClientPacketListener)) {
            return;
        }
        if (!ConnectionMixin.isRenderThread()) {
            return;
        }
        ComponentContents componentContents = disconnectionDetails.reason().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            string = tc.getKey();
        } else {
            string = "unknown";
        }
        String reason = string;
        ConnectionEvent.DisconnectedEvent event = new ConnectionEvent.DisconnectedEvent(reason);
        MixinHelper.postAlways(event);
    }

    @Inject(method={"sendPacket(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendPre(Packet<?> packet, PacketSendListener sendListener, boolean flush, CallbackInfo ci) {
        PacketEvent.PacketSentEvent event = new PacketEvent.PacketSentEvent(packet);
        MixinHelper.postAlways(event);
        if (event.isCanceled()) {
            ci.cancel();
        }
    }
}

