/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.wynntils.core.components.Services;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.ArmSwingEvent;
import com.wynntils.mc.event.ChatScreenCreateEvent;
import com.wynntils.mc.event.DisplayResizeEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.ServerResourcePackEvent;
import com.wynntils.mc.event.TickAlwaysEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.extension.MinecraftExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements MinecraftExtension {
    @Unique
    private RenderTarget wynntils_overridenRenderTarget;

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="RETURN")})
    private void setScreenPost(Screen screen, CallbackInfo ci, @Share(value="oldScreen") LocalRef<Screen> oldScreen) {
        Event event = screen == null ? new ScreenClosedEvent.Post((Screen)oldScreen.get()) : new ScreenOpenedEvent.Post(screen, (Screen)oldScreen.get());
        MixinHelper.post(event);
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void setScreenPre(Screen screen, CallbackInfo ci, @Share(value="oldScreen") LocalRef<Screen> oldScreen) {
        oldScreen.set((Object)((Minecraft)this).screen);
        Event event = screen == null ? new ScreenClosedEvent.Pre((Screen)oldScreen.get()) : new ScreenOpenedEvent.Pre(screen, (Screen)oldScreen.get());
        MixinHelper.postAlways(event);
        if (((ICancellableEvent)event).isCanceled()) {
            ci.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickPost(CallbackInfo ci) {
        MixinHelper.postAlways(new TickAlwaysEvent());
        MixinHelper.post(new TickEvent());
    }

    @Inject(method={"resizeDisplay()V"}, at={@At(value="RETURN")})
    private void resizeDisplayPost(CallbackInfo ci) {
        MixinHelper.postAlways(new DisplayResizeEvent());
    }

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Options;loadSelectedResourcePacks(Lnet/minecraft/server/packs/repository/PackRepository;)V", shift=At.Shift.AFTER)})
    private void onInitialResourcePackLoad(CallbackInfo ci) {
        Services.ResourcePack.preloadResourcePack();
    }

    @Inject(method={"clearDownloadedResourcePacks()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/resources/server/DownloadedPackSource;cleanupAfterDisconnect()V", shift=At.Shift.AFTER)})
    private void handleResourcePackPopPre(CallbackInfo ci) {
        ServerResourcePackEvent.Clear event = new ServerResourcePackEvent.Clear();
        MixinHelper.postAlways(event);
    }

    @WrapWithCondition(method={"startAttack()Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;swing(Lnet/minecraft/world/InteractionHand;)V")})
    private boolean onAttack(LocalPlayer localPlayer, InteractionHand hand) {
        ArmSwingEvent event = new ArmSwingEvent(ArmSwingEvent.ArmSwingContext.ATTACK_OR_START_BREAKING_BLOCK, hand);
        MixinHelper.post(event);
        return !event.isCanceled();
    }

    @WrapMethod(method={"getMainRenderTarget()Lcom/mojang/blaze3d/pipeline/RenderTarget;"})
    private RenderTarget getMainRenderTarget(Operation<RenderTarget> operation) {
        if (this.wynntils_overridenRenderTarget != null) {
            return this.wynntils_overridenRenderTarget;
        }
        return (RenderTarget)operation.call(new Object[0]);
    }

    @WrapOperation(method={"openChatScreen(Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setScreen(Lnet/minecraft/client/gui/screens/Screen;)V")})
    private void wrapOpenChatScreenSetScreen(Minecraft instance, Screen screen, Operation<Void> original, String defaultText) {
        if (screen == null) {
            original.call(new Object[]{instance, screen});
            return;
        }
        ChatScreenCreateEvent event = new ChatScreenCreateEvent(screen, defaultText);
        MixinHelper.post(event);
        original.call(new Object[]{instance, event.getScreen()});
    }

    @Override
    public void setOverridenRenderTarget(RenderTarget renderTarget) {
        this.wynntils_overridenRenderTarget = renderTarget;
    }
}

