/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.mc.mixin;

import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.events.MixinHelper;
import com.wynntils.mc.event.PauseMenuInitEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.TitleScreenInitEvent;
import com.wynntils.mc.extension.ScreenExtension;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
public abstract class ScreenMixin
implements ScreenExtension {
    @Unique
    private TextInputBoxWidget wynntilsFocusedTextInput;

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="HEAD")})
    private void initPre(Minecraft client, int width, int height, CallbackInfo info) {
        Screen screen = (Screen)this;
        if (!(screen instanceof TitleScreen)) {
            return;
        }
        TitleScreen titleScreen = (TitleScreen)screen;
        MixinHelper.postAlways(new TitleScreenInitEvent.Pre(titleScreen));
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="RETURN")})
    private void initPost(Minecraft client, int width, int height, CallbackInfo info) {
        Screen screen = (Screen)this;
        if (screen instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)screen;
            MixinHelper.postAlways(new TitleScreenInitEvent.Post(titleScreen));
        } else if (screen instanceof PauseScreen) {
            PauseScreen pauseMenuScreen = (PauseScreen)screen;
            MixinHelper.post(new PauseMenuInitEvent(pauseMenuScreen));
        }
    }

    @Inject(method={"rebuildWidgets()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init()V")})
    private void onScreenInitPre(CallbackInfo ci) {
        MixinHelper.postAlways(new ScreenInitEvent.Pre((Screen)this, false));
    }

    @Inject(method={"rebuildWidgets()V"}, at={@At(value="RETURN")})
    private void onScreenInitPost(CallbackInfo ci) {
        MixinHelper.postAlways(new ScreenInitEvent.Post((Screen)this, false));
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init()V")})
    private void onFirstScreenInitPre(CallbackInfo ci) {
        MixinHelper.post(new ScreenInitEvent.Pre((Screen)this, true));
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init()V", shift=At.Shift.AFTER)})
    private void onFirstScreenInitPost(CallbackInfo ci) {
        MixinHelper.post(new ScreenInitEvent.Post((Screen)this, true));
    }

    @Inject(method={"Lnet/minecraft/client/gui/screens/Screen;fillCrashDetails(Lnet/minecraft/CrashReport;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void wrapScreenErrorPre(CrashReport crashReport, CallbackInfo ci) {
        Screen screen = Minecraft.getInstance().screen;
        if (!(screen instanceof WynntilsScreen)) {
            return;
        }
        WynntilsScreen wynntilsScreen = (WynntilsScreen)screen;
        wynntilsScreen.wrapCurrentScreenError(crashReport);
        ci.cancel();
    }

    @Override
    @Unique
    public TextInputBoxWidget getFocusedTextInput() {
        return this.wynntilsFocusedTextInput;
    }

    @Override
    @Unique
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.wynntilsFocusedTextInput = focusedTextInput;
    }
}

