/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.type;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.StringUtils;
import java.util.Locale;
import net.minecraft.ChatFormatting;

public enum ShamanMaskType {
    NONE("None", ChatFormatting.GRAY, null),
    LUNATIC("L", ChatFormatting.RED, StyledText.fromString("\u00a7c\ue024")),
    FANATIC("F", ChatFormatting.GOLD, StyledText.fromString("\u00a76\ue023")),
    HERETIC("H", ChatFormatting.AQUA, StyledText.fromString("\u00a7b\ue022")),
    AWAKENED("A", ChatFormatting.DARK_PURPLE, StyledText.fromString("Awakened"));

    private final String alias;
    private final ChatFormatting color;
    private final StyledText parseString;

    private ShamanMaskType(String alias, ChatFormatting color, StyledText parseString) {
        this.alias = alias;
        this.color = color;
        this.parseString = parseString;
    }

    public static ShamanMaskType find(String text) {
        for (ShamanMaskType type : ShamanMaskType.values()) {
            if (!type.alias.equals(text) && !type.getName().equals(text)) continue;
            return type;
        }
        return NONE;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public StyledText getParseString() {
        return this.parseString;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getName() {
        return StringUtils.capitalizeFirst(this.name().toLowerCase(Locale.ROOT));
    }
}

