/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.handlers.scoreboard.ScoreboardSegment;
import com.wynntils.handlers.scoreboard.type.SegmentMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;

public class ActivityTrackerScoreboardPart
extends ScoreboardPart {
    private static final SegmentMatcher TRACKER_MATCHER = SegmentMatcher.fromPattern("Tracked (.*):");
    private static final Pattern SPACER_PATTERN = Pattern.compile("[^a-zA-Z\\[\\d-].*");

    @Override
    public SegmentMatcher getSegmentMatcher() {
        return TRACKER_MATCHER;
    }

    @Override
    public void onSegmentChange(ScoreboardSegment newValue) {
        Matcher matcher;
        List<StyledText> content = newValue.getContent();
        if (content.isEmpty()) {
            WynntilsMod.error("TrackerScoreboardPart: content was empty.");
        }
        if (!(matcher = newValue.getHeader().getMatcher(TRACKER_MATCHER.headerPattern(), StyleType.NONE)).matches()) {
            return;
        }
        ArrayList<String> questNameParts = new ArrayList<String>();
        for (StyledText line : content) {
            if (!line.startsWith("\u00a7f")) break;
            questNameParts.add(line.getNormalized().trim().getStringWithoutFormatting());
        }
        StringBuilder nextTask = new StringBuilder();
        List<StyledText> taskLines = content.subList(questNameParts.size(), content.size());
        for (StyledText line : taskLines) {
            String unformatted = line.getString(StyleType.NONE);
            Matcher spacerMatcher = SPACER_PATTERN.matcher(unformatted);
            if (spacerMatcher.matches() && nextTask.length() - 1 >= 0) {
                nextTask.deleteCharAt(nextTask.length() - 1);
            }
            nextTask.append(line.getString().replaceAll(ChatFormatting.WHITE.toString(), ChatFormatting.AQUA.toString()).replaceAll(ChatFormatting.GRAY.toString(), ChatFormatting.RESET.toString()));
            if (unformatted.endsWith(" ")) continue;
            nextTask.append(" ");
        }
        String type = matcher.group(1);
        StyledText fixedNextTask = StyledText.fromString(nextTask.toString().trim()).getNormalized();
        Models.Activity.updateTracker(String.join((CharSequence)" ", questNameParts), type, fixedNextTask);
    }

    @Override
    public void onSegmentRemove(ScoreboardSegment segment) {
        Models.Activity.resetTracker();
    }

    @Override
    public void reset() {
        Models.Activity.resetTracker();
    }

    @Override
    public String toString() {
        return "TrackerScoreboardPart{}";
    }
}

