/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.characterstats;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.actionbar.event.ActionBarUpdatedEvent;
import com.wynntils.models.characterstats.actionbar.matchers.CombatExperienceSegmentMatcher;
import com.wynntils.models.characterstats.actionbar.segments.CombatExperienceSegment;
import com.wynntils.models.characterstats.event.CombatXpGainEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.TimedSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.neoforged.bus.api.SubscribeEvent;

public final class CombatXpModel
extends Model {
    private static final int[] LEVEL_UP_XP_REQUIREMENTS = new int[]{150, 320, 520, 730, 950, 1060, 1260, 1300, 1500, 1850, 2110, 2400, 2760, 3010, 3380, 3810, 4200, 4790, 5490, 5730, 6310, 6820, 7750, 8450, 9700, 10500, 12000, 13700, 15400, 16600, 18800, 21200, 24000, 25200, 28400, 30000, 33500, 35000, 39000, 43000, 48000, 57300, 63500, 75000, 83000, 92000, 101000, 119000, 131000, 145000, 160000, 185000, 205000, 225000, 246000, 285000, 313000, 340000, 375000, 432200, 472300, 515800, 562800, 613700, 668600, 728000, 792000, 860000, 935000, 1040400, 1154400, 1282600, 1414800, 1567500, 1730400, 1837000, 1954800, 2077600, 2194400, 2325600, 2455000, 2645000, 2845000, 3141100, 3404710, 3782160, 4151400, 4604100, 5057300, 5533840, 6087120, 6685120, 7352800, 8080800, 8725600, 9578400, 10545600, 11585600, 12740000, 14418250, 16280000, 21196500, 23315500, 25649000, 248721250};
    private static final int MAX_LEVEL = 106;
    private float lastTickXp = 0.0f;
    private int trackedLevel = 0;
    private float currentLevelProgress = 0.0f;
    private boolean firstJoinHappened = false;
    private final TimedSet<Float> rawXpGainInLastMinute = new TimedSet(1L, TimeUnit.MINUTES, true);
    private final TimedSet<Float> percentageXpGainInLastMinute = new TimedSet(1L, TimeUnit.MINUTES, true);

    public CombatXpModel() {
        super(List.of());
        Handlers.ActionBar.registerSegment(new CombatExperienceSegmentMatcher());
    }

    @SubscribeEvent
    public void onActionBarUpdate(ActionBarUpdatedEvent event) {
        event.runIfPresent(CombatExperienceSegment.class, this::updateCombatExperience);
    }

    @SubscribeEvent
    public void onXpGain(CombatXpGainEvent event) {
        this.rawXpGainInLastMinute.put(Float.valueOf(event.getGainedXpRaw()));
        this.percentageXpGainInLastMinute.put(Float.valueOf(event.getGainedXpPercentage()));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.WORLD) {
            this.firstJoinHappened = false;
        }
    }

    public CappedValue getCombatLevel() {
        return new CappedValue(Models.CharacterStats.getLevel(), 106);
    }

    public CappedValue getXp() {
        return CappedValue.fromProgress(this.currentLevelProgress, this.getTotalXpPointsNeededToLevelUp());
    }

    public int getXpPointsNeededToLevelUp() {
        return this.getTotalXpPointsNeededToLevelUp() - this.getXp().current();
    }

    private int getTotalXpPointsNeededToLevelUp() {
        int levelIndex = Models.CharacterStats.getLevel() - 1;
        if (levelIndex >= LEVEL_UP_XP_REQUIREMENTS.length) {
            return Integer.MAX_VALUE;
        }
        if (levelIndex < 0) {
            return 0;
        }
        return LEVEL_UP_XP_REQUIREMENTS[levelIndex];
    }

    public TimedSet<Float> getRawXpGainInLastMinute() {
        return this.rawXpGainInLastMinute;
    }

    public TimedSet<Float> getPercentageXpGainInLastMinute() {
        return this.percentageXpGainInLastMinute;
    }

    public long getLastXpGainTimestamp() {
        return this.rawXpGainInLastMinute.getLastAddedTimestamp();
    }

    private void updateCombatExperience(CombatExperienceSegment combatExperienceSegment) {
        int neededXp;
        float progress;
        this.currentLevelProgress = progress = (float)combatExperienceSegment.getProgress().getProgress();
        if (!this.firstJoinHappened) {
            this.lastTickXp = this.getXp().current();
            this.firstJoinHappened = true;
            return;
        }
        float newTickXp = this.getXp().current();
        if (newTickXp == this.lastTickXp) {
            return;
        }
        int newLevel = this.getCombatLevel().current();
        if (this.trackedLevel == 0) {
            this.trackedLevel = newLevel;
        }
        if (newLevel != this.trackedLevel) {
            this.trackedLevel = newLevel;
            this.lastTickXp = 0.0f;
        }
        if ((neededXp = this.getTotalXpPointsNeededToLevelUp()) == 0) {
            return;
        }
        float trackedPercentage = this.lastTickXp != 0.0f ? this.lastTickXp / (float)neededXp : newTickXp / (float)neededXp;
        float gainedXP = newTickXp - this.lastTickXp;
        if (Math.round(gainedXP * 100.0f) / 100 == 0) {
            return;
        }
        float percentGained = gainedXP / (float)neededXp;
        float percentChange = trackedPercentage != percentGained ? percentGained * 100.0f : trackedPercentage * 100.0f;
        this.lastTickXp = newTickXp;
        WynntilsMod.postEvent(new CombatXpGainEvent(gainedXP, percentChange));
    }
}

