/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.combat.label;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.combat.label.DamageLabelInfo;
import com.wynntils.models.stats.type.DamageType;
import com.wynntils.utils.mc.type.Location;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.Entity;

public class DamageLabelParser
implements LabelParser<DamageLabelInfo> {
    private static final String DAMAGE_LABEL_PART = "\u00a7[245bcef](?:\u00a7l)?-(\\d+) (?:\u00a7r\u00a7[245bcef](?:\u00a7l)?)?([\u2764\ue003\ue001\ue004\ue002\ue000\u2620]) ";
    private static final Pattern DAMAGE_LABEL_PART_PATTERN = Pattern.compile("\u00a7[245bcef](?:\u00a7l)?-(\\d+) (?:\u00a7r\u00a7[245bcef](?:\u00a7l)?)?([\u2764\ue003\ue001\ue004\ue002\ue000\u2620]) ");
    private static final Pattern DAMAGE_LABEL_PATTERN = Pattern.compile("(?:\u00a7[245bcef](?:\u00a7l)?-(\\d+) (?:\u00a7r\u00a7[245bcef](?:\u00a7l)?)?([\u2764\ue003\ue001\ue004\ue002\ue000\u2620]) )+");

    @Override
    public DamageLabelInfo getInfo(StyledText label, Location location, Entity entity) {
        Matcher matcher = label.getMatcher(DAMAGE_LABEL_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        HashMap<DamageType, Long> damages = new HashMap<DamageType, Long>();
        Matcher partMatcher = label.getMatcher(DAMAGE_LABEL_PART_PATTERN);
        while (partMatcher.find()) {
            String damageStr = partMatcher.group(1);
            String damageTypeStr = partMatcher.group(2);
            long damage = Long.parseLong(damageStr);
            DamageType damageType = DamageType.fromSymbol(damageTypeStr);
            if (damageType == null) {
                WynntilsMod.warn("Unknown damage type: " + damageTypeStr);
                continue;
            }
            damages.put(damageType, damage);
        }
        if (damages.isEmpty()) {
            WynntilsMod.warn("No valid damage types found in label: " + String.valueOf(label));
            return null;
        }
        return new DamageLabelInfo(label, location, entity, damages);
    }
}

