/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.combat.label;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.type.LabelParser;
import com.wynntils.models.combat.label.KillLabelInfo;
import com.wynntils.models.combat.type.KillCreditType;
import com.wynntils.utils.mc.type.Location;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.entity.Entity;

public class KillLabelParser
implements LabelParser<KillLabelInfo> {
    private static final Pattern KILL_LABEL_PATTERN = Pattern.compile("(?:\u00a7dx\\d )?\u00a77\\[\u00a7f\\+(?:\u00a7d)?(?<combatXp>\\d+)(?:\u00a7f)? Combat XP\u00a77\\](\n(?:\u00a7dx\\d )?(?:\u00a7bx\\d\\.\\d )?(?:\u00a77)?\\[\u00a7f\\+(?:\u00a7(?:b|d))?(?<guildXp>\\d+)(?:\u00a7f)? Guild XP\u00a77\\])?\n\\[(?<killCredit>.*)\\]");

    @Override
    public KillLabelInfo getInfo(StyledText label, Location location, Entity entity) {
        Matcher matcher = label.getMatcher(KILL_LABEL_PATTERN);
        if (!matcher.matches()) {
            return null;
        }
        int combatXp = Integer.parseInt(matcher.group("combatXp"));
        String guildXpStr = matcher.group("guildXp");
        int guildXp = guildXpStr == null ? 0 : Integer.parseInt(guildXpStr);
        String killCreditStr = matcher.group("killCredit");
        KillCreditType killCredit = killCreditStr.equals("Shared") ? KillCreditType.SHARED : KillCreditType.SELF;
        return new KillLabelInfo(label, location, entity, combatXp, guildXp, killCredit);
    }
}

