/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.gui.screens.Screen;

public abstract class Container {
    private final Predicate<Screen> screenPredicate;
    private int containerId;

    protected Container(Pattern titlePattern) {
        this.screenPredicate = screen -> titlePattern.matcher(screen.getTitle().getString()).matches();
    }

    protected Container(Predicate<Screen> screenPredicate) {
        this.screenPredicate = screenPredicate;
    }

    public void setContainerId(int containerId) {
        this.containerId = containerId;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public boolean isScreen(Screen screen) {
        return this.screenPredicate.test(screen);
    }

    public String getContainerName() {
        return this.getClass().getSimpleName().replace("Container", "");
    }
}

