/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear.type;

import com.wynntils.core.components.Services;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;

public enum GearType {
    SPEAR(ClassType.WARRIOR, "spear", Items.IRON_SHOVEL, 0),
    WAND(ClassType.MAGE, "wand", Items.WOODEN_SHOVEL, 1),
    DAGGER(ClassType.ASSASSIN, "dagger", Items.SHEARS, 2),
    BOW(ClassType.ARCHER, "bow", Items.BOW, 3),
    RELIK(ClassType.SHAMAN, "relik", Items.STONE_SHOVEL, 4),
    WEAPON(null, null, 12),
    ACCESSORY(null, null, 13),
    RING(null, "ring", 5),
    BRACELET(null, "bracelet", 6),
    NECKLACE(null, "necklace", 7),
    HELMET(null, Items.LEATHER_HELMET, "helmet", "helmet_skin", List.of(Items.LEATHER_HELMET, Items.CHAINMAIL_HELMET, Items.IRON_HELMET, Items.GOLDEN_HELMET, Items.DIAMOND_HELMET, Items.NETHERITE_HELMET, Items.POTION), 8),
    CHESTPLATE(null, Items.LEATHER_CHESTPLATE, "chestplate", List.of(Items.CHAINMAIL_CHESTPLATE, Items.IRON_CHESTPLATE, Items.GOLDEN_CHESTPLATE, Items.DIAMOND_CHESTPLATE, Items.NETHERITE_CHESTPLATE), 9),
    LEGGINGS(null, Items.LEATHER_LEGGINGS, "leggings", List.of(Items.CHAINMAIL_LEGGINGS, Items.IRON_LEGGINGS, Items.GOLDEN_LEGGINGS, Items.DIAMOND_LEGGINGS, Items.NETHERITE_LEGGINGS), 10),
    BOOTS(null, Items.LEATHER_BOOTS, "boots", List.of(Items.CHAINMAIL_BOOTS, Items.IRON_BOOTS, Items.GOLDEN_BOOTS, Items.DIAMOND_BOOTS, Items.NETHERITE_BOOTS), 11),
    MASTERY_TOME(null, "tome", -1),
    CHARM(null, "charm", -1);

    private final ClassType classReq;
    private final Item defaultItem;
    private final String modelKey;
    private final String skinModelKey;
    private final List<Item> otherItems;
    private final int encodingId;
    private List<Float> modelList = new ArrayList<Float>();
    private static final Map<Integer, GearType> craftedAccessoryMap;

    private GearType(ClassType classReq, Item defaultItem, String modelKey, String skinModelKey, List<Item> otherItems, int encodingId) {
        this.classReq = classReq;
        this.defaultItem = defaultItem;
        this.modelKey = modelKey;
        this.skinModelKey = skinModelKey;
        this.otherItems = otherItems;
        this.encodingId = encodingId;
    }

    private GearType(ClassType classReq, Item defaultItem, String modelKey, List<Item> otherItems, int encodingId) {
        this(classReq, defaultItem, modelKey, null, otherItems, encodingId);
    }

    private GearType(ClassType classReq, String modelKey, Item craftedItem, int encodingId) {
        this(classReq, Items.POTION, modelKey, List.of(craftedItem), encodingId);
    }

    private GearType(ClassType classReq, String modelKey, int encodingId) {
        this(classReq, Items.POTION, modelKey, List.of(), encodingId);
    }

    public static GearType fromString(String typeStr) {
        try {
            return GearType.valueOf(typeStr.toUpperCase(Locale.ROOT).replace(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static GearType fromItemStack(ItemStack itemStack, boolean crafted) {
        Item item = itemStack.getItem();
        CustomModelData customModelData = (CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA);
        if (customModelData != null && !customModelData.floats().isEmpty()) {
            for (GearType gearType : GearType.values()) {
                if (gearType.isReward()) continue;
                List customModelDataValue = customModelData.floats();
                for (Float modelValue : customModelDataValue) {
                    if (!gearType.defaultItem.equals(item) && !gearType.otherItems.contains(item) || !gearType.getModelList().contains(modelValue)) continue;
                    return gearType;
                }
            }
        } else if (crafted) {
            for (GearType gearType : GearType.values()) {
                if ((!gearType.isArmor() || !gearType.defaultItem.equals(item) && !gearType.otherItems.contains(item)) && (!gearType.isWeapon() || !gearType.otherItems.contains(item))) continue;
                return gearType;
            }
            if (item == Items.FLINT_AND_STEEL) {
                int damage = itemStack.getDamageValue();
                return craftedAccessoryMap.getOrDefault(damage, null);
            }
        }
        return null;
    }

    public static GearType fromClassType(ClassType classType) {
        for (GearType gearType : GearType.values()) {
            if (gearType.classReq != classType) continue;
            return gearType;
        }
        return null;
    }

    public static GearType fromEncodingId(int id) {
        for (GearType gearType : GearType.values()) {
            if (gearType.encodingId != id) continue;
            return gearType;
        }
        return null;
    }

    public ClassType getClassReq() {
        return this.classReq;
    }

    public Item getDefaultItem() {
        return this.defaultItem;
    }

    public float getDefaultModel() {
        if (Services.CustomModel.getRange(this.modelKey).isPresent()) {
            return Services.CustomModel.getRange(this.modelKey).get().a().floatValue();
        }
        return -1.0f;
    }

    public int getEncodingId() {
        return this.encodingId;
    }

    public boolean isReward() {
        return this == MASTERY_TOME || this == CHARM;
    }

    public boolean isWeapon() {
        return this.classReq != null || this == WEAPON;
    }

    public boolean isAccessory() {
        return this.defaultItem == Items.FLINT_AND_STEEL || this.defaultItem == Items.POTION;
    }

    public boolean isArmor() {
        return switch (this.ordinal()) {
            case 10, 11, 12, 13 -> true;
            default -> false;
        };
    }

    public boolean isValidWeapon(ClassType classType) {
        if (!this.isWeapon()) {
            return false;
        }
        if (this == WEAPON) {
            return true;
        }
        return this.classReq == classType;
    }

    private List<Float> getModelList() {
        if (this.modelList.isEmpty()) {
            ArrayList<Float> tempModelList = new ArrayList<Float>();
            GearType.addRangeToList(Services.CustomModel.getRange(this.modelKey), tempModelList);
            GearType.addRangeToList(Services.CustomModel.getRange(this.skinModelKey), tempModelList);
            this.modelList = List.copyOf(tempModelList);
        }
        return this.modelList;
    }

    private static void addRangeToList(Optional<Pair<Float, Float>> modelRange, List<Float> out) {
        modelRange.ifPresent(range -> {
            int min = ((Float)range.a()).intValue();
            int max = ((Float)range.b()).intValue();
            IntStream.rangeClosed(min, max).mapToObj(i -> Float.valueOf(i)).forEach(out::add);
        });
    }

    private static Map<Integer, GearType> buildCraftedAccessoryMap() {
        HashMap map = new HashMap();
        IntStream.rangeClosed(1, 17).forEach(i -> map.put(i, RING));
        IntStream.rangeClosed(18, 34).forEach(i -> map.put(i, NECKLACE));
        IntStream.rangeClosed(35, 49).forEach(i -> map.put(i, BRACELET));
        return Map.copyOf(map);
    }

    static {
        craftedAccessoryMap = GearType.buildCraftedAccessoryMap();
    }
}

