/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.horse;

import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.items.game.HorseItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public final class HorseModel
extends Model {
    private static final Map<Integer, Integer> MAX_LEVEL_TIMES = Map.of(10, 1530, 15, 3430, 20, 6080, 25, 9480, 30, 13630, 35, 18530, 40, 24180);

    public HorseModel() {
        super(List.of());
    }

    public Optional<HorseItem> getHorse() {
        int horseSlot = this.findHorseSlotNum();
        if (horseSlot == -1) {
            return Optional.empty();
        }
        return Models.Item.asWynnItem(McUtils.inventory().getItem(horseSlot), HorseItem.class);
    }

    public Optional<Integer> calculateNextLevelSeconds() {
        Optional<HorseItem> optionalHorse = this.getHorse();
        if (optionalHorse.isEmpty()) {
            return Optional.empty();
        }
        HorseItem horseItem = optionalHorse.get();
        if (horseItem.getLevel() == CappedValue.EMPTY || horseItem.getXp() == CappedValue.EMPTY) {
            return Optional.empty();
        }
        if (horseItem.getLevel().current() == horseItem.getLevel().max()) {
            return Optional.empty();
        }
        double levelProgress = ((double)horseItem.getLevel().current() + 0.6666666666666666) / 2.0;
        double xpProgress = 100.0 - (double)horseItem.getXp().current();
        double result = levelProgress * (xpProgress / 100.0) * 60.0;
        return Optional.of((int)Math.ceil(result));
    }

    public Optional<CappedValue> calculateNextLevelCumulativeSeconds() {
        Optional<HorseItem> optionalHorse = this.getHorse();
        if (optionalHorse.isEmpty()) {
            return Optional.empty();
        }
        HorseItem horseItem = optionalHorse.get();
        if (horseItem.getLevel() == CappedValue.EMPTY || horseItem.getXp() == CappedValue.EMPTY) {
            return Optional.empty();
        }
        if (MAX_LEVEL_TIMES.get(horseItem.getLevel().max()) == null) {
            return Optional.empty();
        }
        double result = 0.0;
        double resultMax = MAX_LEVEL_TIMES.get(horseItem.getLevel().max()).intValue();
        for (int levelNumber = 1; levelNumber != horseItem.getLevel().current() + 1; ++levelNumber) {
            double levelProgress = ((double)levelNumber + 0.6666666666666666) / 2.0;
            double xpProgress = 100.0 - (double)horseItem.getXp().current();
            result += levelProgress * 60.0;
            if (levelNumber != horseItem.getLevel().current()) continue;
            result -= levelProgress * (xpProgress / 100.0) * 60.0;
        }
        if (horseItem.getLevel().current() == horseItem.getLevel().max()) {
            result = resultMax;
        }
        return Optional.of(new CappedValue((int)Math.ceil(result), (int)Math.ceil(resultMax)));
    }

    public int findHorseSlotNum() {
        Inventory inventory = McUtils.inventory();
        for (int slotNum = 0; slotNum < 36; ++slotNum) {
            ItemStack itemStack = inventory.getItem(slotNum);
            if (!Models.Item.asWynnItem(itemStack, HorseItem.class).isPresent()) continue;
            return slotNum;
        }
        return -1;
    }

    public AbstractHorse searchForHorseNearby(Player player, int searchRadius) {
        List horses = McUtils.mc().level.getEntitiesOfClass(AbstractHorse.class, new AABB(player.getX() - (double)searchRadius, player.getY() - (double)searchRadius, player.getZ() - (double)searchRadius, player.getX() + (double)searchRadius, player.getY() + (double)searchRadius, player.getZ() + (double)searchRadius));
        return horses.stream().filter(horse -> this.isPlayersHorse((AbstractHorse)horse, player)).findFirst().orElse(null);
    }

    private boolean isPlayersHorse(AbstractHorse horse, Player player) {
        StyledText codedHorseName;
        if (horse == null) {
            return false;
        }
        Component horseName = horse.getCustomName();
        if (horseName == null) {
            return false;
        }
        String playerName = player.getName().getString();
        StyledText defaultName = StyledText.fromString("\u00a7f" + playerName + "\u00a77's horse");
        return defaultName.equals(codedHorseName = StyledText.fromComponent(horseName)) || codedHorseName.endsWith("\u00a77 [" + playerName + "]");
    }
}

