/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.housing;

import com.wynntils.core.components.Model;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.utils.mc.StyledTextUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.bus.api.SubscribeEvent;

public class HousingModel
extends Model {
    private static final Pattern HOUSING_EDIT_PATTERN = Pattern.compile("\u00a7e(?:\ue008\ue002|\ue001) You (?<state>are now in|have left) housing edit mode. Type \u00a7b/housing edit\u00a7e to switch back.");
    private boolean onHousing = false;
    private boolean inEditMode = false;
    private String currentHousingName = "";

    public HousingModel() {
        super(List.of());
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.WORLD) {
            return;
        }
        this.updateHousingState(false, "");
    }

    @SubscribeEvent
    public void onChatMessage(ChatMessageEvent.Match event) {
        if (!this.onHousing) {
            return;
        }
        StyledText message = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        Matcher matcher = message.getMatcher(HOUSING_EDIT_PATTERN);
        if (matcher.matches()) {
            this.inEditMode = matcher.group("state").equals("are now in");
        }
    }

    public void updateHousingState(boolean onHousing, String housingName) {
        this.onHousing = onHousing;
        this.currentHousingName = housingName;
        if (!onHousing) {
            this.inEditMode = false;
        }
    }

    public boolean isOnHousing() {
        return this.onHousing;
    }

    public String getCurrentHousingName() {
        return this.currentHousingName;
    }

    public boolean isInEditMode() {
        return this.inEditMode;
    }
}

