/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.ingredients;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.Dependency;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.ingredients.type.IngredientPosition;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.AbstractItemInfoDeserializer;
import com.wynntils.models.wynnitem.type.ItemMaterial;
import com.wynntils.models.wynnitem.type.ItemObtainInfo;
import com.wynntils.models.wynnitem.type.ItemObtainType;
import com.wynntils.utils.JsonUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class IngredientInfoRegistry {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(IngredientInfo.class, (Object)new IngredientInfoDeserializer()).create();
    private List<IngredientInfo> ingredientInfoRegistry = List.of();
    private Map<String, IngredientInfo> ingredientInfoLookup = Map.of();
    private Map<String, IngredientInfo> ingredientInfoLookupApiName = Map.of();

    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_INGREDIENTS, Dependency.multi(Models.WynnItem, Set.of(UrlId.DATA_STATIC_ITEM_OBTAIN_V2, UrlId.DATA_STATIC_MATERIAL_CONVERSION))).handleJsonObject(this::handleIngredients);
    }

    public IngredientInfo getFromDisplayName(String ingredientName) {
        return this.ingredientInfoLookup.get(ingredientName);
    }

    public IngredientInfo getFromApiName(String ingredientName) {
        return this.ingredientInfoLookupApiName.get(ingredientName);
    }

    public Stream<IngredientInfo> getIngredientInfoStream() {
        return this.ingredientInfoRegistry.stream();
    }

    private void handleIngredients(JsonObject json) {
        ArrayList<IngredientInfo> registry = new ArrayList<IngredientInfo>();
        for (Map.Entry entry : json.entrySet()) {
            JsonObject ingredientObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            ingredientObject.addProperty("name", (String)entry.getKey());
            IngredientInfo ingredientInfo = (IngredientInfo)GSON.fromJson((JsonElement)ingredientObject, IngredientInfo.class);
            registry.add(ingredientInfo);
        }
        HashMap<String, IngredientInfo> lookupMap = new HashMap<String, IngredientInfo>();
        HashMap<String, IngredientInfo> altLookupMap = new HashMap<String, IngredientInfo>();
        for (IngredientInfo ingredientInfo : registry) {
            lookupMap.put(ingredientInfo.name(), ingredientInfo);
            if (!ingredientInfo.apiName().isPresent()) continue;
            altLookupMap.put(ingredientInfo.apiName().get(), ingredientInfo);
        }
        this.ingredientInfoRegistry = registry;
        this.ingredientInfoLookup = lookupMap;
        this.ingredientInfoLookupApiName = altLookupMap;
    }

    private static final class IngredientInfoDeserializer
    extends AbstractItemInfoDeserializer<IngredientInfo> {
        private IngredientInfoDeserializer() {
        }

        public IngredientInfo deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            Pair<String, String> names = this.parseNames(json);
            String displayName = names.key();
            String internalName = names.value();
            Optional<String> internalNameOpt = Optional.ofNullable(internalName);
            int tier = JsonUtils.getNullableJsonInt(json, "tier");
            JsonObject requirements = JsonUtils.getNullableJsonObject(json, "requirements");
            int level = requirements.get("level").getAsInt();
            List<ProfessionType> professions = this.parseProfessions(requirements);
            ItemMaterial material = this.parseMaterial(json, displayName);
            List<ItemObtainInfo> obtainInfo = this.parseDroppedBy(json);
            JsonObject consumableIdsJson = JsonUtils.getNullableJsonObject(json, "consumableOnlyIDs");
            int duration = JsonUtils.getNullableJsonInt(consumableIdsJson, "duration");
            int charges = JsonUtils.getNullableJsonInt(consumableIdsJson, "charges");
            JsonObject itemIdsJson = JsonUtils.getNullableJsonObject(json, "itemOnlyIDs");
            int durabilityModifier = JsonUtils.getNullableJsonInt(itemIdsJson, "durabilityModifier") / 1000;
            List<Pair<Skill, Integer>> skillRequirements = this.getSkillRequirements(itemIdsJson);
            Map<IngredientPosition, Integer> positionModifiers = this.getPositionModifiers(json);
            List<Pair<StatType, RangedValue>> variableStats = this.parseVariableIngredientStats(json);
            return new IngredientInfo(displayName, tier, level, internalNameOpt, material, professions, skillRequirements, positionModifiers, obtainInfo, duration, charges, durabilityModifier, variableStats);
        }

        private List<ProfessionType> parseProfessions(JsonObject json) {
            ArrayList<ProfessionType> professions = new ArrayList<ProfessionType>();
            JsonArray professionsJson = json.get("skills").getAsJsonArray();
            for (JsonElement professionJson : professionsJson) {
                String professionName = professionJson.getAsString();
                ProfessionType professionType = ProfessionType.fromString(professionName);
                professions.add(professionType);
            }
            return List.copyOf(professions);
        }

        private ItemMaterial parseMaterial(JsonObject json, String name) {
            ItemMaterial material = this.parseMaterial(json);
            if (material == null) {
                WynntilsMod.warn("Ingredient DB is missing material for " + name);
                return ItemMaterial.fromItemId("minecraft:air", 0);
            }
            return material;
        }

        private List<ItemObtainInfo> parseDroppedBy(JsonObject json) {
            ArrayList<ItemObtainInfo> obtainInfo = new ArrayList<ItemObtainInfo>();
            HashSet<String> mobNames = new HashSet<String>();
            if (json.has("droppedBy")) {
                JsonArray droppedBy = json.getAsJsonArray("droppedBy");
                for (JsonElement droppedByElement : droppedBy) {
                    JsonObject droppedByJson = droppedByElement.getAsJsonObject();
                    String mobName2 = droppedByJson.get("name").getAsString();
                    if (mobName2.equals("Ingredient Dummy")) continue;
                    mobNames.add(mobName2);
                }
            }
            mobNames.forEach(mobName -> obtainInfo.add(new ItemObtainInfo(ItemObtainType.SPECIFIC_MOB_DROP, Optional.of(mobName))));
            return obtainInfo;
        }

        private List<Pair<Skill, Integer>> getSkillRequirements(JsonObject itemIdsJson) {
            if (itemIdsJson == null) {
                return List.of();
            }
            ArrayList<Pair<Skill, Integer>> skillRequirements = new ArrayList<Pair<Skill, Integer>>();
            for (Skill skill : Skill.values()) {
                String requirementName = skill.getDisplayName().toLowerCase(Locale.ROOT) + "Requirement";
                int requirementValue = JsonUtils.getNullableJsonInt(itemIdsJson, requirementName);
                if (requirementValue == 0) continue;
                skillRequirements.add(Pair.of(skill, requirementValue));
            }
            return List.copyOf(skillRequirements);
        }

        private Map<IngredientPosition, Integer> getPositionModifiers(JsonObject json) {
            JsonObject positionsJson = JsonUtils.getNullableJsonObject(json, "ingredientPositionModifiers");
            if (positionsJson.isEmpty()) {
                return Map.of();
            }
            HashMap<IngredientPosition, Integer> positionModifiers = new HashMap<IngredientPosition, Integer>();
            for (IngredientPosition position : IngredientPosition.values()) {
                int value = JsonUtils.getNullableJsonInt(positionsJson, position.getApiName());
                if (value == 0) continue;
                positionModifiers.put(position, value);
            }
            return Map.copyOf(positionModifiers);
        }

        private List<Pair<StatType, RangedValue>> parseVariableIngredientStats(JsonObject json) {
            ArrayList<Pair<StatType, RangedValue>> list = new ArrayList<Pair<StatType, RangedValue>>();
            JsonObject identificationsJson = JsonUtils.getNullableJsonObject(json, "identifications");
            for (Map.Entry entry : identificationsJson.entrySet()) {
                StatType statType = Models.Stat.fromApiName((String)entry.getKey());
                if (statType == null) {
                    WynntilsMod.warn("Ingredient DB contains invalid stat type " + (String)entry.getKey());
                    continue;
                }
                JsonObject rangeJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                int low = JsonUtils.getNullableJsonInt(rangeJson, "min");
                int high = JsonUtils.getNullableJsonInt(rangeJson, "max");
                RangedValue range = RangedValue.of(low, high);
                list.add(Pair.of(statType, range));
            }
            return List.copyOf(list);
        }
    }
}

