/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.game;

import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GameItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.items.items.game.AmplifierItem;
import com.wynntils.utils.MathUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.ItemStack;

public final class AmplifierAnnotator
implements GameItemAnnotator {
    private static final Pattern AMPLIFIER_PATTERN = Pattern.compile("^\u00a7bCorkian Amplifier (I{1,3})$");

    @Override
    public ItemAnnotation getAnnotation(ItemStack itemStack, StyledText name) {
        Matcher ampMatcher = name.getMatcher(AMPLIFIER_PATTERN);
        if (!ampMatcher.matches()) {
            return null;
        }
        int tier = MathUtils.integerFromRoman(ampMatcher.group(1));
        return new AmplifierItem(tier);
    }
}

