/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.EmeraldValuedItemProperty;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.models.items.properties.NumberedTierItemProperty;
import com.wynntils.utils.MathUtils;

public class EmeraldPouchItem
extends GameItem
implements NamedItemProperty,
NumberedTierItemProperty,
EmeraldValuedItemProperty {
    private final int tier;
    private final int value;
    private final int capacity;

    public EmeraldPouchItem(int tier, int value) {
        this.tier = tier;
        this.value = value;
        int maxValue = 0;
        switch (tier % 3) {
            case 0: {
                maxValue = 54;
                break;
            }
            case 1: {
                maxValue = 9;
                break;
            }
            case 2: {
                maxValue = 27;
            }
        }
        this.capacity = tier >= 7 ? (tier - 6) * 262144 : (tier >= 4 ? maxValue * 4096 : maxValue * 64);
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int getEmeraldValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return "Emerald Pouch [Tier " + MathUtils.toRoman(this.tier) + "]";
    }

    @Override
    public String toString() {
        return "EmeraldPouchItem{tier=" + this.tier + ", value=" + this.value + "}";
    }
}

