/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.DurableItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.models.items.properties.NumberedTierItemProperty;
import com.wynntils.models.items.properties.ProfessionItemProperty;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.profession.type.ToolProfile;
import com.wynntils.utils.type.CappedValue;
import java.util.List;

public class GatheringToolItem
extends GameItem
implements NumberedTierItemProperty,
DurableItemProperty,
LeveledItemProperty,
ProfessionItemProperty {
    private final ToolProfile toolProfile;
    private final CappedValue durability;

    public GatheringToolItem(ToolProfile toolProfile, CappedValue durability) {
        this.toolProfile = toolProfile;
        this.durability = durability;
    }

    public ToolProfile getToolProfile() {
        return this.toolProfile;
    }

    @Override
    public CappedValue getDurability() {
        return this.durability;
    }

    @Override
    public int getTier() {
        return this.toolProfile.tier();
    }

    @Override
    public int getLevel() {
        return this.toolProfile.getLevel();
    }

    @Override
    public String toString() {
        return "GatheringToolItem{toolProfile=" + String.valueOf(this.toolProfile) + ", durability=" + String.valueOf(this.durability) + "}";
    }

    @Override
    public List<ProfessionType> getProfessionTypes() {
        return List.of(this.toolProfile.toolType().getProfessionType());
    }
}

