/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.rewards.type;

import com.wynntils.utils.StringUtils;
import java.util.Optional;

public enum TomeType {
    WEAPON(true, true),
    ARMOUR(true, true),
    GUILD("Allegiance", true, false),
    SLAYING(false, true),
    GATHERING(false, true),
    DUNGEONEERING(false, true),
    LOOTRUN(true, false);

    private final String typeString;
    private final boolean hasVariants;
    private final boolean isTiered;

    private TomeType(boolean hasVariants, boolean isTiered) {
        this.typeString = StringUtils.capitalized(this.name());
        this.hasVariants = hasVariants;
        this.isTiered = isTiered;
    }

    private TomeType(String typeString, boolean hasVariants, boolean isTiered) {
        this.typeString = typeString;
        this.hasVariants = hasVariants;
        this.isTiered = isTiered;
    }

    public String getName() {
        return this.typeString;
    }

    public boolean hasVariants() {
        return this.hasVariants;
    }

    public boolean isTiered() {
        return this.isTiered;
    }

    public static Optional<TomeType> fromString(String typeStr) {
        for (TomeType type : TomeType.values()) {
            if (!type.typeString.equals(typeStr)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

