/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats.builders;

import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.stats.type.StatUnit;
import java.util.Locale;

public enum MiscStatKind {
    HEALTH("Health", StatUnit.RAW, "rawHealth", "HEALTHBONUS"),
    HEALTH_REGEN_PERCENT("Health Regen", StatUnit.PERCENT, "healthRegen"),
    HEALTH_REGEN_RAW("Health Regen", StatUnit.RAW, "healthRegenRaw"),
    HEALING_EFFICIENCY("Healing Efficiency", StatUnit.PERCENT, "healingEfficiency", "HEALING_EFFICIENCY"),
    LIFE_STEAL("Life Steal", StatUnit.PER_3_S, "lifeSteal"),
    MANA_REGEN("Mana Regen", StatUnit.PER_5_S, "manaRegen"),
    MANA_STEAL("Mana Steal", StatUnit.PER_3_S, "manaSteal"),
    MAX_MANA_RAW("Max Mana", StatUnit.RAW, "rawMaxMana", "MAX_MANA"),
    WALK_SPEED("Walk Speed", StatUnit.PERCENT, "walkSpeed", "SPEED"),
    SPRINT("Sprint", StatUnit.PERCENT, "sprint", "STAMINA"),
    SPRINT_REGEN("Sprint Regen", StatUnit.PERCENT, "sprintRegen", "STAMINA_REGEN"),
    JUMP_HEIGHT("Jump Height", StatUnit.RAW, "jumpHeight", "JUMP_HEIGHT"),
    ATTACK_SPEED("Attack Speed", StatUnit.TIER, "rawAttackSpeed", "ATTACKSPEED"),
    MAIN_ATTACK_RANGE("Main Attack Range", StatUnit.PERCENT, "mainAttackRange", "MAIN_ATTACK_RANGE"),
    REFLECTION("Reflection", StatUnit.PERCENT, "reflection"),
    THORNS("Thorns", StatUnit.PERCENT, "thorns"),
    EXPLODING("Exploding", StatUnit.PERCENT, "exploding"),
    POISON("Poison", StatUnit.PER_3_S, "poison"),
    KNOCKBACK("Knockback", StatUnit.PERCENT, "knockback"),
    SLOW_ENEMY("Slow Enemy", StatUnit.PERCENT, "slowEnemy", "SLOW_ENEMY"),
    WEAKEN_ENEMY("Weaken Enemy", StatUnit.PERCENT, "weakenEnemy", "WEAKEN_ENEMY"),
    STEALING("Stealing", StatUnit.PERCENT, "stealing", "EMERALDSTEALING"),
    XP_BONUS("XP Bonus", StatUnit.PERCENT, "xpBonus"),
    LOOT_BONUS("Loot Bonus", StatUnit.PERCENT, "lootBonus"),
    LOOT_QUALITY("Loot Quality", StatUnit.PERCENT, "lootQuality", "LOOT_QUALITY"),
    GATHER_XP_BONUS("Gather XP Bonus", StatUnit.PERCENT, "gatherXpBonus", "GATHER_XP_BONUS"),
    GATHER_SPEED("Gather Speed", StatUnit.PERCENT, "gatherSpeed", "GATHER_SPEED"),
    SLAYING_XP("Slaying XP", StatUnit.PERCENT, "slayingXP", "SLAYING_XP", StatType.SpecialStatType.TOME_BASE_STAT),
    GATHERING_XP("Gathering XP", StatUnit.PERCENT, "gatheringXP", "GATHERING_XP", StatType.SpecialStatType.TOME_BASE_STAT),
    DUNGEON_XP("Dungeon XP", StatUnit.PERCENT, "dungeonXP", "DUNGEON_XP", StatType.SpecialStatType.TOME_BASE_STAT),
    LEVELED_XP_BONUS("XP from Lv. ${} content", StatUnit.PERCENT, "leveledXpBonus", "LEVELED_XP_BONUS", StatType.SpecialStatType.CHARM_LEVELED_STAT),
    LEVELED_LOOT_BONUS("Loot from Lv. ${} content", StatUnit.PERCENT, "leveledLootBonus", "LEVELED_LOOT_BONUS", StatType.SpecialStatType.CHARM_LEVELED_STAT);

    private final String displayName;
    private final String apiName;
    private final StatUnit unit;
    private final String internalRollName;
    private final StatType.SpecialStatType specialStatType;

    private MiscStatKind(String displayName, StatUnit unit, String apiName, String internalRollName, StatType.SpecialStatType specialStatType) {
        this.displayName = displayName;
        this.apiName = apiName;
        this.unit = unit;
        this.internalRollName = internalRollName;
        this.specialStatType = specialStatType;
    }

    private MiscStatKind(String displayName, StatUnit unit, String apiName, String internalRollName) {
        this.displayName = displayName;
        this.apiName = apiName;
        this.unit = unit;
        this.internalRollName = internalRollName;
        this.specialStatType = StatType.SpecialStatType.NONE;
    }

    private MiscStatKind(String displayName, StatUnit unit, String apiName) {
        this(displayName, unit, apiName, apiName.toUpperCase(Locale.ROOT));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getInternalRollName() {
        return this.internalRollName;
    }

    public StatUnit getUnit() {
        return this.unit;
    }

    public StatType.SpecialStatType getSpecialStatType() {
        return this.specialStatType;
    }
}

