/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.war.bossbar;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.models.war.type.WarTowerState;
import com.wynntils.utils.type.RangedValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WarTowerBar
extends TrackedBar {
    private static final Pattern TOWER_BAR_PATTERN = Pattern.compile("\u00a73\\[(?<guild>.+)\\] \u00a7b(?<territory>.+) Tower\u00a77 - \u00a74. (?<health>.+)\u00a77 \\(\u00a76(?<defense>.+)%\u00a77\\) - \u00a7..{1,2} (?<damagemin>.+)-(?<damagemax>.+)\u00a77 \\(\u00a7b(?<attackspeed>.+)x\u00a77\\)");

    public WarTowerBar() {
        super(TOWER_BAR_PATTERN);
    }

    @Override
    public void onUpdateName(Matcher match) {
        WarTowerState towerState = new WarTowerState(Long.parseLong(match.group("health")), Double.parseDouble(match.group("defense")), RangedValue.of(Integer.parseInt(match.group("damagemin")), Integer.parseInt(match.group("damagemax"))), Double.parseDouble(match.group("attackspeed")), System.currentTimeMillis());
        Models.GuildWarTower.onTowerDamaged(match.group("guild"), match.group("territory"), towerState);
    }

    @Override
    protected void reset() {
        super.reset();
        Models.GuildWarTower.resetTowerState();
    }
}

