/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombSortOrder;
import com.wynntils.models.worlds.type.BombType;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;

public class BombBellOverlay
extends Overlay {
    @Persisted
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted
    private final Config<Float> fontScale = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Boolean> groupBombs = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> maxBombs = new Config<Integer>(5);
    @Persisted
    private final Config<BombSortOrder> sortOrder = new Config<BombSortOrder>(BombSortOrder.NEWEST);
    @Persisted
    private final Config<Boolean> showCombatBombs = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showDungeonBombs = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showLootBombs = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showLootChestBombs = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showProfessionXpBombs = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> showProfessionSpeedBombs = new Config<Boolean>(true);
    private final Map<BombType, Supplier<Boolean>> bombTypeMap;
    private Comparator<BombInfo> comparator;
    private TextRenderSetting textRenderSetting;
    private List<TextRenderTask> renderTasks;

    public BombBellOverlay() {
        super(new OverlayPosition(130.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(200.0f, 110.0f));
        Map.Entry[] entryArray = new Map.Entry[6];
        entryArray[0] = Map.entry(BombType.COMBAT_XP, this.showCombatBombs::get);
        entryArray[1] = Map.entry(BombType.DUNGEON, this.showDungeonBombs::get);
        entryArray[2] = Map.entry(BombType.LOOT, this.showLootBombs::get);
        entryArray[3] = Map.entry(BombType.LOOT_CHEST, this.showLootChestBombs::get);
        entryArray[4] = Map.entry(BombType.PROFESSION_XP, this.showProfessionXpBombs::get);
        entryArray[5] = Map.entry(BombType.PROFESSION_SPEED, this.showProfessionSpeedBombs::get);
        this.bombTypeMap = Map.ofEntries(entryArray);
        this.renderTasks = new ArrayList<TextRenderTask>();
        this.updateTextRenderSetting();
    }

    @Override
    protected boolean hideWhenNoGui() {
        return false;
    }

    @Override
    protected boolean isVisible() {
        return !Models.Bomb.getBombBells().isEmpty();
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), this.renderTasks, this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), ((Float)this.fontScale.get()).floatValue());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        BufferedFontRenderer.getInstance().renderTextsWithAlignment(guiGraphics.pose(), bufferSource, this.getRenderX(), this.getRenderY(), List.of(new TextRenderTask(StyledText.fromString("\u00a76Combat XP\u00a77 on \u00a7fWC32 \u00a76(16m 35s)"), this.textRenderSetting), new TextRenderTask(StyledText.fromString("\u00a76Profession Speed\u00a77 on \u00a7fWC1 \u00a76(3m 12s)"), this.textRenderSetting)), this.getWidth(), this.getHeight(), this.getRenderHorizontalAlignment(), this.getRenderVerticalAlignment(), ((Float)this.fontScale.get()).floatValue());
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.updateTextRenderSetting();
    }

    @Override
    public void tick() {
        Stream<BombInfo> bombsToRender = Models.Bomb.getBombBellStream((Boolean)this.groupBombs.get(), (BombSortOrder)((Object)this.sortOrder.get()), (Integer)this.maxBombs.get()).filter(bombInfo -> {
            BombType bombType = bombInfo.bomb();
            Supplier<Boolean> bombTypeSupplier = this.bombTypeMap.get((Object)bombType);
            return bombTypeSupplier != null && bombTypeSupplier.get() != false;
        });
        this.renderTasks = bombsToRender.map(bombInfo -> new TextRenderTask(bombInfo.asString(), this.textRenderSetting)).toList();
    }

    private void updateTextRenderSetting() {
        this.textRenderSetting = TextRenderSetting.DEFAULT.withMaxWidth(this.getWidth()).withHorizontalAlignment(this.getRenderHorizontalAlignment()).withTextShadow((TextShadow)this.textShadow.get());
    }
}

