/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.BarOverlay;
import com.wynntils.core.consumers.overlays.ContainerOverlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.models.token.event.TokenGatekeeperEvent;
import com.wynntils.utils.colors.ColorChatFormatting;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.neoforged.bus.api.SubscribeEvent;

public class TokenBarsOverlay
extends ContainerOverlay<TokenBarOverlay> {
    public TokenBarsOverlay() {
        super(new OverlayPosition(70.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(81.0f, 84.0f), ContainerOverlay.GrowDirection.DOWN, HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
    }

    @SubscribeEvent
    public void onGatekeeperAdded(TokenGatekeeperEvent.Added event) {
        this.addChild(new TokenBarOverlay(this.size() + 1));
    }

    @SubscribeEvent
    public void onGatekeeperRemoved(TokenGatekeeperEvent.Removed event) {
        this.clearChildren();
        for (int i = 1; i <= Models.Token.getGatekeepers().size(); ++i) {
            this.addChild(new TokenBarOverlay(i));
        }
    }

    @Override
    protected List<TokenBarOverlay> getPreviewChildren() {
        return List.of(new TokenBarOverlay(0), new TokenBarOverlay(1));
    }

    protected static final class TokenBarOverlay
    extends BarOverlay {
        @Persisted
        protected final Config<ColorChatFormatting> color = new Config<ColorChatFormatting>(ColorChatFormatting.GOLD);
        @Persisted
        protected final Config<UniversalTexture> barTexture = new Config<UniversalTexture>(UniversalTexture.A);

        private TokenBarOverlay(int id) {
            super(id, new OverlaySize(81.0f, 21.0f));
            this.horizontalAlignmentOverride.store(HorizontalAlignment.RIGHT);
            this.verticalAlignmentOverride.store(VerticalAlignment.TOP);
        }

        @Override
        public BarOverlay.BarOverlayTemplatePair getTemplate() {
            return new BarOverlay.BarOverlayTemplatePair(String.valueOf(((ColorChatFormatting)((Object)this.color.get())).getChatFormatting()) + "{token_type(" + this.getId() + ")}: {token(" + this.getId() + ")}", "token(" + this.getId() + ")");
        }

        @Override
        public BarOverlay.BarOverlayTemplatePair getPreviewTemplate() {
            return new BarOverlay.BarOverlayTemplatePair(String.valueOf(((ColorChatFormatting)((Object)this.color.get())).getChatFormatting()) + "Tokens: 3/10", "capped(3; 10)");
        }

        @Override
        protected void renderBar(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, float renderHeight, float progress) {
            BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, Texture.UNIVERSAL_BAR, this.getRenderColor(), this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, ((UniversalTexture)this.barTexture.get()).getTextureY1(), Texture.UNIVERSAL_BAR.width(), ((UniversalTexture)this.barTexture.get()).getTextureY2(), progress);
        }

        @Override
        public CustomColor getRenderColor() {
            return CustomColor.fromChatFormatting(((ColorChatFormatting)((Object)this.color.get())).getChatFormatting());
        }

        @Override
        public Texture getTexture() {
            return Texture.UNIVERSAL_BAR;
        }

        @Override
        protected float getTextureHeight() {
            return ((UniversalTexture)this.barTexture.get()).getHeight();
        }
    }
}

