/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.custombars;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.BarOverlay;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.overlays.custombars.CustomBarOverlayBase;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ErrorOr;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;

public class UniversalTexturedCustomBarOverlay
extends CustomBarOverlayBase {
    @Persisted
    private final Config<UniversalTexture> barTexture = new Config<UniversalTexture>(UniversalTexture.A);
    @Persisted
    private final Config<String> colorTemplate = new Config<String>("");
    private ErrorOr<CustomColor> colorCache = ErrorOr.of(CommonColors.WHITE);

    public UniversalTexturedCustomBarOverlay(int id) {
        super(id, new OverlaySize(81.0f, 21.0f));
    }

    @Override
    public CustomColor getRenderColor() {
        return this.colorCache.hasError() ? CommonColors.WHITE : this.colorCache.getValue();
    }

    @Override
    public Texture getTexture() {
        return Texture.UNIVERSAL_BAR;
    }

    @Override
    protected float getTextureHeight() {
        return ((UniversalTexture)this.barTexture.get()).getHeight();
    }

    @Override
    protected void renderOrErrorMessage(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        if (this.colorCache.hasError()) {
            StyledText[] errorMessage = new StyledText[]{StyledText.fromString("\u00a7c\u00a7l" + I18n.get((String)"feature.wynntils.customBarsOverlay.overlay.universalTexturedCustomBar.colorTemplate.error", (Object[])new Object[0]) + " " + this.getTranslatedName()), StyledText.fromUnformattedString(this.colorCache.getError())};
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.pose(), bufferSource, errorMessage, this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        } else {
            super.renderOrErrorMessage(guiGraphics, bufferSource, deltaTracker, window);
        }
    }

    @Override
    protected void renderBar(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, float renderHeight, float progress) {
        BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, Texture.UNIVERSAL_BAR, this.colorCache.getValue(), this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, ((UniversalTexture)this.barTexture.get()).getTextureY1(), Texture.UNIVERSAL_BAR.width(), ((UniversalTexture)this.barTexture.get()).getTextureY2(), progress);
    }

    @Override
    public void tick() {
        super.tick();
        String template = (String)this.colorTemplate.get();
        if (template.isEmpty()) {
            this.colorCache = ErrorOr.of(CommonColors.WHITE);
            return;
        }
        String formattedTemplate = StyledText.join("", Managers.Function.doFormatLines(template)).getString();
        this.colorCache = Managers.Function.tryGetRawValueOfType(formattedTemplate, CustomColor.class);
    }

    @Override
    protected BarOverlay.BarOverlayTemplatePair getActualPreviewTemplate() {
        return new BarOverlay.BarOverlayTemplatePair("3/10", "capped(3; 10)");
    }
}

