/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.gamebars;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.bossbar.type.BossBarProgress;
import com.wynntils.models.abilities.AbilityModel;
import com.wynntils.models.abilities.bossbars.MomentumBar;
import com.wynntils.overlays.gamebars.BaseBarOverlay;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.UniversalTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class MomentumBarOverlay
extends BaseBarOverlay {
    @Persisted
    private final Config<CustomColor> maximumColor = new Config<CustomColor>(CommonColors.GREEN);

    public MomentumBarOverlay() {
        super(new OverlayPosition(-30.0f, -150.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(81.0f, 21.0f), CommonColors.RED);
    }

    @Override
    public BossBarProgress progress() {
        return AbilityModel.momentumBar.getBarProgress();
    }

    @Override
    protected Class<? extends TrackedBar> getTrackedBarClass() {
        return MomentumBar.class;
    }

    @Override
    public boolean isVisible() {
        return AbilityModel.momentumBar.isActive();
    }

    @Override
    protected void renderBar(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, float renderHeight, float progress) {
        BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, Texture.UNIVERSAL_BAR, AbilityModel.momentumBar.isMax() ? (CustomColor)this.maximumColor.get() : (CustomColor)this.textColor.get(), this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, ((UniversalTexture)this.barTexture.get()).getTextureY1(), Texture.UNIVERSAL_BAR.width(), ((UniversalTexture)this.barTexture.get()).getTextureY2(), progress);
    }

    @Override
    protected void renderText(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, String text) {
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(AbilityModel.momentumBar.getMomentum() + " ").append(StyledText.fromComponent((Component)Component.literal((String)"\ue013").withStyle(Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"common"))))), this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, 0.0f, AbilityModel.momentumBar.isMax() ? (CustomColor)this.maximumColor.get() : (CustomColor)this.textColor.get(), this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
    }
}

