/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.activities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityRewardType;
import com.wynntils.screens.activities.ContentBookHolder;
import com.wynntils.screens.activities.widgets.ContentBookActionWidget;
import com.wynntils.screens.activities.widgets.ContentBookRewardWidget;
import com.wynntils.screens.activities.widgets.ContentBookScrollButton;
import com.wynntils.screens.activities.widgets.ContentBookSearchWidget;
import com.wynntils.screens.activities.widgets.ContentBookWidget;
import com.wynntils.screens.activities.widgets.WynntilsMenuTag;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public class WynntilsContentBookScreen
extends WynntilsScreen
implements WrappedScreen {
    private static final Integer MAX_COLUMNS = 3;
    private static final Integer MAX_ROWS = 6;
    private static final int WIDGETS_PER_PAGE = MAX_ROWS * MAX_COLUMNS;
    private static final StyledText VARIOUS_EMERALDS = StyledText.fromString("Various Emeralds");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+) (?:.*)");
    private static final ResourceLocation BUTTON_CLICK_ID = ResourceLocation.withDefaultNamespace((String)"wynn.ui.click");
    private static final SoundEvent BUTTON_CLICK_SOUND = SoundEvent.createVariableRangeEvent((ResourceLocation)BUTTON_CLICK_ID);
    private List<List<ContentBookWidget>> contentBookWidgets = new ArrayList<List<ContentBookWidget>>();
    private final Map<Integer, ContentBookActionWidget> contentBookActionWidgets = new TreeMap<Integer, ContentBookActionWidget>();
    private ActivityInfo trackedActivity = null;
    private boolean goToFinalPage = false;
    private int currentPage = 0;
    private StyledText trackedDescription = null;
    private List<ContentBookRewardWidget> trackedRewards = new ArrayList<ContentBookRewardWidget>();
    private boolean scrollUpActive = false;
    private boolean scrollDownActive = false;
    private int offsetX;
    private int offsetY;
    private int trackedRewardsX;
    private ContentBookScrollButton scrollUpButton;
    private ContentBookScrollButton scrollDownButton;
    private SearchWidget searchWidget;
    private final WrappedScreenInfo wrappedScreenInfo;
    private final ContentBookHolder holder;

    public WynntilsContentBookScreen(WrappedScreenInfo wrappedScreenInfo, ContentBookHolder holder) {
        super((Component)Component.translatable((String)"screens.wynntils.content.name"));
        this.wrappedScreenInfo = wrappedScreenInfo;
        this.holder = holder;
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.width - Texture.CUSTOM_CONTENT_BOOK_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.CUSTOM_CONTENT_BOOK_BACKGROUND.height()) / 2.0f);
        this.searchWidget = new ContentBookSearchWidget(this.offsetX + 29, this.offsetY + 6, 235, 20, s -> this.reloadContentBookWidgets(false), this);
        this.addRenderableWidget((GuiEventListener)this.searchWidget);
        this.scrollUpButton = new ContentBookScrollButton(this.offsetX + 173, this.offsetY + 153, 16, 16, Texture.UP_COLORED_ICON, b -> {
            if (this.currentPage == 0) {
                this.holder.scrollUp();
                this.goToFinalPage = true;
            } else {
                this.scrollPage(-1);
            }
        }, List.of(Component.literal((String)"Scroll Up")));
        this.addRenderableWidget((GuiEventListener)this.scrollUpButton);
        this.scrollDownButton = new ContentBookScrollButton(this.offsetX + 245, this.offsetY + 153, 16, 16, Texture.DOWN_COLORED_ICON, b -> {
            if (this.currentPage == this.contentBookWidgets.size() - 1) {
                this.holder.scrollDown();
                this.goToFinalPage = false;
            } else {
                this.scrollPage(1);
            }
        }, List.of(Component.literal((String)"Scroll Down")));
        this.addRenderableWidget((GuiEventListener)this.scrollDownButton);
        this.addRenderableWidget((GuiEventListener)new WynntilsMenuTag(this.offsetX + 333, this.offsetY + 151, b -> {
            McUtils.sendPacket(new ServerboundContainerClosePacket(this.wrappedScreenInfo.containerId()));
            McUtils.player().containerMenu = McUtils.player().inventoryMenu;
            McUtils.setScreen(WynntilsMenuScreen.create());
        }));
        this.holder.reloadActions();
        this.reloadContentBookWidgets(true);
    }

    public void onClose() {
        McUtils.player().closeContainer();
        super.onClose();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.contentBookWidgets.get(this.currentPage).forEach(renderable -> renderable.render(guiGraphics, mouseX, mouseY, partialTick));
        this.contentBookActionWidgets.values().forEach(renderable -> renderable.render(guiGraphics, mouseX, mouseY, partialTick));
        this.renderables.forEach(renderable -> renderable.render(guiGraphics, mouseX, mouseY, partialTick));
        if (!Models.CombatXp.getCombatLevel().isAtCap()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.contentBook.xpToLevelUp", (Object[])new Object[]{String.format(Locale.ROOT, "%,d", Models.CombatXp.getXpPointsNeededToLevelUp()), Models.CombatXp.getCombatLevel().current() + 1})), this.offsetX + 18, this.offsetY + 160, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        if (this.trackedActivity != null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(EnumUtils.toNiceString(this.trackedActivity.type()) + " - " + this.trackedActivity.name()), (float)(this.offsetX + 24), (float)(this.offsetY + 178), this.trackedActivity.type().getColor(), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 0.9f);
            if (this.trackedDescription != null) {
                FontRenderer.getInstance().renderAlignedTextInBox(poseStack, this.trackedDescription, (float)(this.offsetX + 24), (float)(this.offsetX + 410), (float)(this.offsetY + 188), (float)(this.offsetY + 208), 386.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 0.9f);
            }
            if (!this.trackedRewards.isEmpty()) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.contentBook.rewards")), (float)this.trackedRewardsX, (float)(this.offsetY + 213), CustomColor.fromChatFormatting(ChatFormatting.LIGHT_PURPLE), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 0.9f);
                this.trackedRewards.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
            }
        } else {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.contentBook.selectToTrack")), this.offsetX + 4, this.offsetX + 410, this.offsetY + 178, this.offsetY + 213, 386.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        this.renderTooltips(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseClicked(mouseX, mouseY, button);
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        if (scrollValue == 1.0) {
            if (this.currentPage == this.contentBookWidgets.size() - 1) {
                this.holder.pressSlot(ContentBookHolder.SCROLL_DOWN_SLOTS.b());
                this.goToFinalPage = false;
            } else {
                this.scrollPage(1);
            }
        } else if (scrollValue == -1.0) {
            if (this.currentPage == 0) {
                this.holder.pressSlot(ContentBookHolder.SCROLL_UP_SLOTS.b());
                this.goToFinalPage = true;
            } else {
                this.scrollPage(-1);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public WrappedScreenInfo getWrappedScreenInfo() {
        return this.wrappedScreenInfo;
    }

    public void reloadContentBookWidgets(boolean resetPage) {
        this.contentBookWidgets = new ArrayList<List<ContentBookWidget>>();
        Map<Integer, Pair<ItemStack, ActivityInfo>> activities = this.holder.getActivities();
        int baseX = this.offsetX + 18;
        int baseY = this.offsetY + 35;
        ArrayList<ContentBookWidget> currentWidgets = new ArrayList<ContentBookWidget>();
        this.contentBookWidgets.add(currentWidgets);
        int widgetIndex = 0;
        for (Map.Entry<Integer, Pair<ItemStack, ActivityInfo>> entry : activities.entrySet()) {
            int indexInPage = widgetIndex % WIDGETS_PER_PAGE;
            int row = indexInPage / MAX_COLUMNS;
            int col = indexInPage % MAX_COLUMNS;
            int x = baseX + col * 133;
            int y = baseY + row * 18;
            boolean searchMatch = StringUtils.partialMatch(entry.getValue().b().name(), this.searchWidget.getTextBoxInput());
            currentWidgets.add(new ContentBookWidget(x, y, entry.getValue(), entry.getKey(), this.holder, searchMatch));
            if (indexInPage != WIDGETS_PER_PAGE - 1 || ++widgetIndex >= activities.size()) continue;
            currentWidgets = new ArrayList();
            this.contentBookWidgets.add(currentWidgets);
        }
        ActivityInfo newTrackedActivity = this.holder.getTrackedActivityInfo().orElse(null);
        if (newTrackedActivity != null) {
            this.trackedActivity = newTrackedActivity;
            if (this.trackedActivity.description().isPresent()) {
                this.trackedDescription = this.trackedActivity.description().get().map(part -> {
                    if (part.getPartStyle().getColor().equals(CustomColor.fromChatFormatting(ChatFormatting.GRAY))) {
                        return part.withStyle(partStyle -> partStyle.withColor(CommonColors.WHITE));
                    }
                    if (part.getPartStyle().getColor().equals(CustomColor.fromChatFormatting(ChatFormatting.WHITE))) {
                        return part.withStyle(partStyle -> partStyle.withColor(CommonColors.AQUA));
                    }
                    return part;
                });
            }
            if (!this.trackedActivity.rewards().isEmpty()) {
                this.createRewardWidgets(this.trackedActivity.rewards());
            }
        }
        if (!resetPage) {
            this.goToFinalPage = false;
            return;
        }
        this.currentPage = this.goToFinalPage ? this.contentBookWidgets.size() - 1 : 0;
        this.updateScrollButtonsVisibility();
    }

    public void setDialogueHistoryItem(ItemStack item, int slot) {
        this.contentBookActionWidgets.put(slot, new ContentBookActionWidget(this.offsetX + 399, this.offsetY + 8, item, b -> this.holder.pressSlot(slot, (int)b)));
    }

    public void setScrollUpItem(ItemStack item) {
        this.scrollUpActive = !item.isEmpty();
        this.updateScrollButtonsVisibility();
    }

    public void setFilterItem(ItemStack item, int slot) {
        this.contentBookActionWidgets.put(slot, new ContentBookActionWidget(this.offsetX + 297, this.offsetY + 8, item, b -> this.holder.pressSlot(slot, (int)b)));
    }

    public void setSortItem(ItemStack item, int slot) {
        this.contentBookActionWidgets.put(slot, new ContentBookActionWidget(this.offsetX + 315, this.offsetY + 8, item, b -> this.holder.pressSlot(slot, (int)b)));
    }

    public void setPlayerProgressItem(ItemStack item, int slot) {
        this.contentBookActionWidgets.put(slot, new ContentBookActionWidget(this.offsetX + 381, this.offsetY + 8, item, b -> this.holder.pressSlot(slot, (int)b)));
    }

    public void setScrollDownItem(ItemStack item) {
        this.scrollDownActive = !item.isEmpty();
        this.updateScrollButtonsVisibility();
    }

    public void removeTrackedActivity() {
        this.trackedActivity = null;
    }

    private void createRewardWidgets(Map<ActivityRewardType, List<StyledText>> rewards) {
        this.trackedRewards = new ArrayList<ContentBookRewardWidget>();
        int x = this.offsetX + 410;
        ArrayList<Map.Entry<ActivityRewardType, List<StyledText>>> reversedEntries = new ArrayList<Map.Entry<ActivityRewardType, List<StyledText>>>(rewards.entrySet());
        Collections.reverse(reversedEntries);
        for (Map.Entry entry : reversedEntries) {
            StyledText firstText;
            List<MutableComponent> tooltip = ((List)entry.getValue()).stream().map(StyledText::getComponent).toList();
            StyledText renderedText = null;
            int widgetWidth = 10;
            ActivityRewardType type = (ActivityRewardType)((Object)entry.getKey());
            StyledText styledText = firstText = ((List)entry.getValue()).isEmpty() ? null : (StyledText)((List)entry.getValue()).getFirst();
            if (type == ActivityRewardType.EMERALDS && !VARIOUS_EMERALDS.equals(firstText) || type == ActivityRewardType.XP) {
                Matcher matcher = firstText.getMatcher(NUMBER_PATTERN);
                if (matcher.matches()) {
                    String numberText = StringUtils.integerToShortString(Long.parseLong(matcher.group(1))) + (type == ActivityRewardType.XP ? " XP" : "\u00b2");
                    renderedText = StyledText.fromString(numberText);
                    int textWidth = FontRenderer.getInstance().getFont().width(numberText);
                    widgetWidth += 2 + textWidth;
                } else {
                    WynntilsMod.error("Failed to extract reward number from " + String.valueOf(firstText));
                }
            }
            this.trackedRewards.add(new ContentBookRewardWidget(x -= widgetWidth, this.offsetY + 213, widgetWidth, type.getTexture(), tooltip, renderedText));
            x -= 2;
        }
        this.trackedRewardsX = (int)((float)x - (float)FontRenderer.getInstance().getFont().width(I18n.get((String)"screens.wynntils.contentBook.rewards", (Object[])new Object[0])) * 0.9f);
    }

    private void scrollPage(int direction) {
        this.currentPage += direction;
        McUtils.playSoundMaster(BUTTON_CLICK_SOUND);
        this.updateScrollButtonsVisibility();
    }

    private void updateScrollButtonsVisibility() {
        this.scrollUpButton.visible = this.scrollUpActive || this.currentPage != 0;
        this.scrollDownButton.visible = this.scrollDownActive || this.currentPage < this.contentBookWidgets.size() - 1;
    }

    private void renderBackgroundTexture(PoseStack poseStack) {
        RenderUtils.drawTexturedRect(poseStack, Texture.CUSTOM_CONTENT_BOOK_BACKGROUND, this.offsetX, this.offsetY);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (GuiEventListener child : this.getWidgetsForIteration().toList()) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            if (!child.isMouseOver((double)mouseX, (double)mouseY)) continue;
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            break;
        }
    }

    private Stream<GuiEventListener> getWidgetsForIteration() {
        return Stream.concat(this.children().stream(), Stream.concat(this.contentBookWidgets.get(this.currentPage).stream(), this.contentBookActionWidgets.values().stream()));
    }
}

