/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.ItemSearchHelperWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class ItemSearchWidget
extends SearchWidget {
    private final List<ItemProviderType> supportedProviderTypes;
    private final boolean supportsSorting;
    private final ItemSearchHelperWidget helperWidget;
    private ItemSearchQuery searchQuery;
    private final Consumer<ItemSearchQuery> onSearchQueryUpdateConsumer;

    public ItemSearchWidget(int x, int y, int width, int height, List<ItemProviderType> supportedProviderTypes, boolean supportsSorting, Consumer<ItemSearchQuery> onSearchQueryUpdateConsumer, TextboxScreen textboxScreen) {
        super(x, y, width, height, null, textboxScreen);
        this.supportedProviderTypes = supportedProviderTypes;
        this.helperWidget = new ItemSearchHelperWidget(x + width - 14, y + 6, Texture.INFO.width() / 3, Texture.INFO.height() / 3, Texture.INFO, true, supportedProviderTypes);
        this.supportsSorting = supportsSorting;
        this.onSearchQueryUpdateConsumer = onSearchQueryUpdateConsumer;
        this.searchQuery = Services.ItemFilter.createSearchQuery("", supportsSorting, supportedProviderTypes);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.helperWidget.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.helperWidget.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void renderText(PoseStack poseStack, String renderedText, int renderedTextStart, String firstPortion, String highlightedPortion, String lastPortion, Font font, int firstWidth, int highlightedWidth, int lastWidth, boolean defaultText) {
        if (defaultText || !this.getTextBoxInput().equals(this.searchQuery.queryString())) {
            super.renderText(poseStack, renderedText, renderedTextStart, firstPortion, highlightedPortion, lastPortion, font, firstWidth, highlightedWidth, lastWidth, defaultText);
            return;
        }
        int charIndex = renderedTextStart;
        StyledText firstPortionStyled = StyledText.EMPTY;
        for (char c : firstPortion.toCharArray()) {
            firstPortionStyled = firstPortionStyled.append(this.getStyledText(charIndex++, c));
        }
        StyledText highlightedPortionStyled = StyledText.EMPTY;
        for (char c : highlightedPortion.toCharArray()) {
            highlightedPortionStyled = highlightedPortionStyled.append(this.getStyledText(charIndex++, c));
        }
        StyledText lastPortionStyled = StyledText.EMPTY;
        for (char c : lastPortion.toCharArray()) {
            lastPortionStyled = lastPortionStyled.append(this.getStyledText(charIndex++, c));
        }
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, firstPortionStyled, (float)(this.getX() + this.textPadding), (float)(this.getX() + this.width - this.textPadding - lastWidth - highlightedWidth), (float)this.getY() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        FontRenderer.getInstance().renderAlignedHighlightedTextInBox(poseStack, highlightedPortionStyled, this.getX() + this.textPadding + firstWidth, this.getX() + this.width - this.textPadding - lastWidth, (float)this.getY() + 6.5f, (float)this.getY() + 6.5f, 0.0f, CommonColors.BLUE, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, lastPortionStyled, (float)(this.getX() + this.textPadding + firstWidth + highlightedWidth), (float)(this.getX() + this.width - this.textPadding), (float)this.getY() + 6.5f, 0.0f, defaultText ? CommonColors.LIGHT_GRAY : CommonColors.WHITE, HorizontalAlignment.LEFT, TextShadow.NORMAL);
        this.drawCursor(poseStack, this.getX() + font.width(renderedText.substring(0, Math.min(this.cursorPosition, renderedText.length()))) + this.textPadding - 2, (float)this.getY() + 6.5f, VerticalAlignment.TOP, false);
    }

    private StyledText getStyledText(int charIndex, char c) {
        for (Pair<ChatFormatting, Pair<Integer, Integer>> colorRange : this.searchQuery.colorRanges()) {
            if (charIndex < colorRange.value().key() || charIndex >= colorRange.value().value()) continue;
            return StyledText.fromString(String.valueOf(colorRange.key()) + String.valueOf(c));
        }
        return StyledText.fromString(String.valueOf(c));
    }

    public void setX(int x) {
        super.setX(x);
        this.helperWidget.setX(x + this.width - 14);
    }

    public void setY(int y) {
        super.setY(y);
        this.helperWidget.setY(y + 6);
    }

    @Override
    protected int getMaxTextWidth() {
        return this.width - 22;
    }

    @Override
    protected void onUpdate(String text) {
        this.searchQuery = Services.ItemFilter.createSearchQuery(text, this.supportsSorting, this.supportedProviderTypes);
        this.onSearchQueryUpdateConsumer.accept(this.searchQuery);
        if (this.searchQuery.errors().isEmpty()) {
            this.setTooltip(null);
        } else {
            this.setTooltip(Tooltip.create((Component)Component.literal((String)String.join((CharSequence)"\n\n", this.searchQuery.errors())).withStyle(ChatFormatting.RED)));
        }
    }

    public ItemSearchQuery getSearchQuery() {
        return this.searchQuery;
    }
}

