/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.colorpicker.widgets;

import com.wynntils.screens.colorpicker.ColorPickerScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SaturationBrightnessWidget
extends AbstractWidget {
    private final ColorPickerScreen colorPickerScreen;
    private boolean cursorHeld = false;
    private CustomColor color;
    private int cursorX;
    private int cursorY;

    public SaturationBrightnessWidget(int x, int y, int width, int height, ColorPickerScreen colorPickerScreen, CustomColor baseColor) {
        super(x, y, width, height, (Component)Component.literal((String)"Saturation Brightness Widget"));
        this.colorPickerScreen = colorPickerScreen;
        float[] hsbColor = baseColor.asHSB();
        this.color = CustomColor.fromHSV(hsbColor[0], 1.0f, 1.0f, 1.0f);
        this.cursorX = (int)Mth.clamp((float)((float)width * hsbColor[1]), (float)0.0f, (float)width);
        this.cursorY = (int)Mth.clamp((float)((float)height * (1.0f - hsbColor[2])), (float)0.0f, (float)height);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.fillSidewaysGradient(guiGraphics.pose(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0, CommonColors.WHITE, this.color.withAlpha(255));
        RenderUtils.fillGradient(guiGraphics.pose(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0, CommonColors.WHITE.withAlpha(0), CommonColors.BLACK);
        RenderUtils.drawRectBorders(guiGraphics.pose(), CommonColors.BLACK, this.getX() + this.cursorX - 2, this.getY() + this.cursorY - 2, this.getX() + this.cursorX + 2, this.getY() + this.cursorY + 2, 2.0f, 1.0f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.cursorX = (int)(mouseX - (double)this.getX());
        this.cursorY = (int)(mouseY - (double)this.getY());
        this.cursorHeld = true;
        this.updateValue(this.cursorX, this.cursorY);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.cursorHeld) {
            return false;
        }
        this.cursorX = Mth.clamp((int)((int)(mouseX - (double)this.getX())), (int)0, (int)this.getWidth());
        this.cursorY = Mth.clamp((int)((int)(mouseY - (double)this.getY())), (int)0, (int)this.getHeight());
        this.updateValue(this.cursorX, this.cursorY);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.cursorHeld = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void setColor(CustomColor color) {
        this.color = color;
    }

    public void updateCursor(float saturation, float brightness) {
        this.cursorX = (int)Mth.clamp((float)((float)this.width * saturation), (float)0.0f, (float)this.width);
        this.cursorY = (int)Mth.clamp((float)((float)this.height * (1.0f - brightness)), (float)0.0f, (float)this.height);
    }

    private void updateValue(double x, double y) {
        float newSaturation = (float)Mth.clamp((double)(x / (double)this.getWidth()), (double)0.0, (double)1.0);
        float newBrightness = (float)(1.0 - Mth.clamp((double)(y / (double)this.getHeight()), (double)0.0, (double)1.0));
        this.colorPickerScreen.setSaturation(newSaturation);
        this.colorPickerScreen.setBrightness(newBrightness);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

