/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.crowdsourcing.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.crowdsource.CrowdSourcedDataManager;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataType;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.wynntils.DataCrowdSourcingFeature;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.crowdsourcing.WynntilsCrowdSourcingSettingsScreen;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ConfirmedBoolean;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class CrowdSourcedDataWidget
extends WynntilsButton
implements TooltipProvider {
    private static final Pair<CustomColor, CustomColor> BUTTON_COLOR = Pair.of(new CustomColor(181, 174, 151), new CustomColor(121, 116, 101));
    private final CrowdSourcedDataType crowdSourcedDataType;
    private final WynntilsCrowdSourcingSettingsScreen crowdSourcingSettingsScreen;

    public CrowdSourcedDataWidget(int x, int y, int width, int height, CrowdSourcedDataType crowdSourcedDataType, WynntilsCrowdSourcingSettingsScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)crowdSourcedDataType.name()));
        this.crowdSourcedDataType = crowdSourcedDataType;
        this.crowdSourcingSettingsScreen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor backgroundColor = this.isHovered ? BUTTON_COLOR.b() : BUTTON_COLOR.a();
        RenderUtils.drawRect(poseStack, backgroundColor, this.getX(), this.getY(), 0.0f, this.width, this.height);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.crowdSourcedDataType.getTranslatedName()), this.getX() + 14, this.getY() + 1, this.width - 15, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.0f);
        Texture stateTexture = switch (Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType)) {
            default -> throw new MatchException(null, null);
            case ConfirmedBoolean.FALSE -> Texture.ACTIVITY_CANNOT_START;
            case ConfirmedBoolean.TRUE -> Texture.ACTIVITY_FINISHED;
            case ConfirmedBoolean.UNCONFIRMED -> Texture.QUESTION_MARK;
        };
        RenderUtils.drawTexturedRect(poseStack, stateTexture.resource(), this.getX() + 1, this.getY() + 1, stateTexture.width(), stateTexture.height(), stateTexture.width(), stateTexture.height());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType) == ConfirmedBoolean.TRUE) {
                ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).put(this.crowdSourcedDataType, ConfirmedBoolean.FALSE);
                Managers.Config.saveConfig();
                return true;
            }
            if (!Managers.CrowdSourcedData.isDataCollectionEnabled()) {
                Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).userEnabled.setValue(true);
            }
            ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).put(this.crowdSourcedDataType, ConfirmedBoolean.TRUE);
            Managers.Config.saveConfig();
            return true;
        }
        if (button == 1) {
            ConfirmedBoolean dataCollectionState = Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType);
            if (dataCollectionState == ConfirmedBoolean.UNCONFIRMED) {
                ((Map)Managers.Feature.getFeatureInstance(DataCrowdSourcingFeature.class).crowdSourcedDataTypeEnabledMap.get()).put(this.crowdSourcedDataType, ConfirmedBoolean.FALSE);
                Managers.Config.saveConfig();
                return true;
            }
            Set data = Managers.CrowdSourcedData.getData(this.crowdSourcedDataType);
            String jsonString = JsonManager.GSON.toJson(Map.of(CrowdSourcedDataManager.CURRENT_GAME_VERSION, data));
            McUtils.mc().keyboardHandler.setClipboard(jsonString);
            return true;
        }
        return false;
    }

    public void onPress() {
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.literal((String)this.crowdSourcedDataType.getTranslatedName()).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD));
        lines.add((Component)Component.empty());
        lines.add((Component)Component.literal((String)this.crowdSourcedDataType.getTranslatedDescription()).withStyle(ChatFormatting.GRAY));
        lines.add((Component)Component.empty());
        ConfirmedBoolean dataCollectionState = Managers.CrowdSourcedData.getDataCollectionState(this.crowdSourcedDataType);
        if (!Managers.CrowdSourcedData.isDataCollectionEnabled()) {
            lines.add((Component)Component.translatable((String)"feature.wynntils.dataCrowdSourcing.button.enableWithFeature").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.DARK_GREEN));
        } else if (dataCollectionState != ConfirmedBoolean.TRUE) {
            lines.add((Component)Component.translatable((String)"feature.wynntils.dataCrowdSourcing.button.enable").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GREEN));
        } else {
            lines.add((Component)Component.translatable((String)"feature.wynntils.dataCrowdSourcing.button.disable").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        }
        if (dataCollectionState == ConfirmedBoolean.UNCONFIRMED) {
            lines.add((Component)Component.translatable((String)"feature.wynntils.dataCrowdSourcing.button.disableUnconfirmed").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        } else {
            lines.add((Component)Component.translatable((String)"feature.wynntils.dataCrowdSourcing.button.copy").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.YELLOW));
        }
        return ComponentUtils.wrapTooltips(lines, 200);
    }
}

