/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.wynnitem.type.ItemObtainInfo;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class GuideItemStack
extends ItemStack {
    protected GuideItemStack(ItemStack itemStack, ItemAnnotation annotation, String baseName) {
        super((ItemLike)itemStack.getItem(), 1);
        this.applyComponents(itemStack.getComponentsPatch());
        Handlers.Item.updateItem(this, annotation, StyledText.fromString(baseName));
    }

    protected void appendObtainInfo(List<Component> tooltipLines, List<ItemObtainInfo> itemObtainInfos) {
        tooltipLines.add((Component)Component.empty());
        tooltipLines.add((Component)Component.literal((String)"Obtain from:").withStyle(ChatFormatting.GRAY));
        for (ItemObtainInfo obtainInfo : itemObtainInfos) {
            MutableComponent obtainSourceType = Component.literal((String)obtainInfo.sourceType().getDisplayName());
            if (obtainInfo.name().isPresent()) {
                obtainSourceType.append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY));
                obtainSourceType.append((Component)Component.literal((String)obtainInfo.name().get()).withStyle(ChatFormatting.YELLOW));
            }
            tooltipLines.add((Component)obtainSourceType);
        }
    }
}

