/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.aspect;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.models.aspects.type.AspectInfo;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.AspectItem;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public class GuideAspectItemStack
extends GuideItemStack {
    private static final MutableComponent LEGENDARY_TAG = Component.literal((String)"\ue060\udaff\udfff\ue03b\udaff\udfff\ue034\udaff\udfff\ue036\udaff\udfff\ue034\udaff\udfff\ue03d\udaff\udfff\ue033\udaff\udfff\ue030\udaff\udfff\ue041\udaff\udfff\ue048\udaff\udfff\ue061\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue03f\udaff\udfff\ue034\udaff\udfff\ue032\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfa0\u00a70\ue00b\ue004\ue006\ue004\ue00d\ue003\ue000\ue011\ue018 \ue000\ue012\ue00f\ue004\ue002\ue013\udb00\udc02");
    private static final MutableComponent FABLED_TAG = Component.literal((String)"\ue060\udaff\udfff\ue035\udaff\udfff\ue030\udaff\udfff\ue031\udaff\udfff\ue03b\udaff\udfff\ue034\udaff\udfff\ue033\udaff\udfff\ue061\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue03f\udaff\udfff\ue034\udaff\udfff\ue032\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfb2\u00a70\ue005\ue000\ue001\ue00b\ue004\ue003 \ue000\ue012\ue00f\ue004\ue002\ue013\udb00\udc02");
    private static final MutableComponent MYTHIC_TAG = Component.literal((String)"\ue060\udaff\udfff\ue03c\udaff\udfff\ue048\udaff\udfff\ue043\udaff\udfff\ue037\udaff\udfff\ue038\udaff\udfff\ue032\udaff\udfff\ue061\udaff\udfff\ue030\udaff\udfff\ue042\udaff\udfff\ue03f\udaff\udfff\ue034\udaff\udfff\ue032\udaff\udfff\ue043\udaff\udfff\ue062\udaff\udfb4\u00a70\ue00c\ue018\ue013\ue007\ue008\ue002 \ue000\ue012\ue00f\ue004\ue002\ue013\udb00\udc02");
    private static final ResourceLocation RARITY_TAG_FONT = ResourceLocation.withDefaultNamespace((String)"banner/box");
    private final AspectInfo aspectInfo;
    private final MutableComponent name;
    private final int tier;
    private List<Component> generatedTooltip;

    public GuideAspectItemStack(AspectInfo aspectInfo, int tier) {
        super(aspectInfo.itemMaterial().itemStack(), new AspectItem(aspectInfo, tier), aspectInfo.name());
        this.aspectInfo = aspectInfo;
        this.name = Component.literal((String)aspectInfo.name()).withStyle(aspectInfo.gearTier().getChatFormatting());
        this.tier = tier;
        this.buildTooltip();
    }

    public Component getHoverName() {
        return this.name;
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag flag) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>(this.generatedTooltip);
        tooltipLines.add((Component)Component.empty());
        if (Services.Favorites.isFavorite(this)) {
            tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").withStyle(ChatFormatting.GREEN));
        }
        return tooltipLines;
    }

    public void buildTooltip() {
        this.generatedTooltip = new ArrayList<Component>();
        this.generatedTooltip.add((Component)Component.literal((String)this.aspectInfo.name()).withStyle(this.aspectInfo.gearTier().getChatFormatting()));
        this.generatedTooltip.add((Component)Component.empty());
        int threshold = this.aspectInfo.effects().get(this.tier - 1).a();
        if (this.tier > 1) {
            threshold -= this.aspectInfo.effects().get(this.tier - 2).a().intValue();
        }
        MutableComponent tierLine = this.tier == this.aspectInfo.effects().size() ? Component.literal((String)("           Tier " + MathUtils.toRoman(this.tier))).withStyle(this.aspectInfo.gearTier().getChatFormatting()).append((Component)Component.literal((String)(" [" + threshold + "] [MAX]")).withStyle(ChatFormatting.GRAY)) : Component.literal((String)("     Tier " + MathUtils.toRoman(this.tier))).withStyle(this.aspectInfo.gearTier().getChatFormatting()).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)("Tier " + MathUtils.toRoman(this.tier + 1))).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(" [" + threshold + "]")).withStyle(ChatFormatting.GRAY));
        this.generatedTooltip.add((Component)tierLine);
        this.generatedTooltip.add((Component)Component.empty());
        this.aspectInfo.effects().get(this.tier - 1).b().forEach(line -> this.generatedTooltip.add((Component)line.getComponent()));
        this.generatedTooltip.add((Component)Component.empty());
        MutableComponent classLine = Models.Character.getClassType() == this.aspectInfo.classType() ? Component.literal((String)"\u2714 ").withStyle(ChatFormatting.GREEN) : Component.literal((String)"\u2716 ").withStyle(ChatFormatting.RED);
        classLine.append((Component)Component.literal((String)"Class Req: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)this.aspectInfo.classType().getFullName()).withStyle(ChatFormatting.WHITE));
        this.generatedTooltip.add((Component)classLine);
        this.generatedTooltip.add((Component)Component.empty());
        Style rarityStyle = Style.EMPTY.withColor(this.aspectInfo.gearTier().getChatFormatting()).withFont(RARITY_TAG_FONT);
        MutableComponent rarityLine = this.getRarityTag().withStyle(rarityStyle);
        this.generatedTooltip.add((Component)rarityLine);
    }

    public AspectInfo getAspectInfo() {
        return this.aspectInfo;
    }

    public int getTier() {
        return this.tier;
    }

    private MutableComponent getRarityTag() {
        return switch (this.aspectInfo.gearTier()) {
            case GearTier.MYTHIC -> MYTHIC_TAG;
            case GearTier.FABLED -> FABLED_TAG;
            default -> LEGENDARY_TAG;
        };
    }
}

