/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.charm;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipBuilder;
import com.wynntils.models.items.items.game.CharmItem;
import com.wynntils.models.rewards.type.CharmInfo;
import com.wynntils.screens.guides.GuideItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public class GuideCharmItemStack
extends GuideItemStack {
    private final CharmInfo charmInfo;
    private final MutableComponent name;
    private List<Component> generatedTooltip;

    public GuideCharmItemStack(CharmInfo charmInfo) {
        super(charmInfo.metaInfo().material().itemStack(), new CharmItem(charmInfo, null), charmInfo.name());
        this.charmInfo = charmInfo;
        this.name = Component.literal((String)charmInfo.name()).withStyle(charmInfo.tier().getChatFormatting());
        this.generatedTooltip = List.of();
    }

    public Component getHoverName() {
        return this.name;
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag flag) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>(this.generatedTooltip);
        this.appendObtainInfo(tooltipLines, this.charmInfo.metaInfo().obtainInfo());
        tooltipLines.add((Component)Component.empty());
        if (Services.Favorites.isFavorite(this)) {
            tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").withStyle(ChatFormatting.GREEN));
        }
        return tooltipLines;
    }

    public CharmInfo getCharmInfo() {
        return this.charmInfo;
    }

    public void buildTooltip() {
        IdentifiableTooltipBuilder tooltipBuilder = Handlers.Tooltip.buildNew(new CharmItem(this.charmInfo, null), true, false);
        this.generatedTooltip = tooltipBuilder.getTooltipLines(Models.Character.getClassType());
        Optional<CharmItem> charmItemOpt = Models.Item.asWynnItem(this, CharmItem.class);
        if (charmItemOpt.isEmpty()) {
            return;
        }
        charmItemOpt.get().getData().clear("tooltip");
    }
}

