/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.gear;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipBuilder;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.screens.guides.GuideItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public final class GuideGearItemStack
extends GuideItemStack {
    private final GearInfo gearInfo;
    private final MutableComponent name;
    private List<Component> generatedTooltip;

    public GuideGearItemStack(GearInfo gearInfo) {
        super(gearInfo.metaInfo().material().itemStack(), new GearItem(gearInfo, null), gearInfo.name());
        this.gearInfo = gearInfo;
        this.name = Component.literal((String)gearInfo.name()).withStyle(gearInfo.tier().getChatFormatting());
        this.generatedTooltip = List.of();
    }

    public Component getHoverName() {
        return this.name;
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag flag) {
        ArrayList<Component> tooltipLines = new ArrayList<Component>(this.generatedTooltip);
        this.appendObtainInfo(tooltipLines, Models.Gear.getObtainInfo(this.gearInfo));
        tooltipLines.add((Component)Component.empty());
        if (Services.Favorites.isFavorite(this)) {
            tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").withStyle(ChatFormatting.GREEN));
        }
        tooltipLines.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.open").withStyle(ChatFormatting.RED));
        return tooltipLines;
    }

    public GearInfo getGearInfo() {
        return this.gearInfo;
    }

    public void buildTooltip() {
        IdentifiableTooltipBuilder tooltipBuilder = Handlers.Tooltip.buildNew(new GearItem(this.gearInfo, null), true, false);
        this.generatedTooltip = tooltipBuilder.getTooltipLines(Models.Character.getClassType());
        Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(this, GearItem.class);
        if (gearItemOpt.isEmpty()) {
            return;
        }
        gearItemOpt.get().getData().clear("tooltip");
    }
}

