/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.ingredient;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.ingredients.type.IngredientPosition;
import com.wynntils.models.ingredients.type.IngredientTierFormatting;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.screens.guides.GuideItemStack;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;

public final class GuideIngredientItemStack
extends GuideItemStack {
    private final IngredientInfo ingredientInfo;
    private final List<MutableComponent> guideTooltip;

    public GuideIngredientItemStack(IngredientInfo ingredientInfo) {
        super(ingredientInfo.material().itemStack(), new IngredientItem(ingredientInfo), ingredientInfo.name());
        this.ingredientInfo = ingredientInfo;
        this.guideTooltip = this.generateGuideTooltip();
    }

    public List<Component> getTooltipLines(Item.TooltipContext context, Player player, TooltipFlag isAdvanced) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(this.getHoverName());
        tooltip.addAll(this.guideTooltip);
        this.appendObtainInfo(tooltip, Models.Ingredient.getObtainInfo(this.ingredientInfo));
        tooltip.add((Component)Component.empty());
        if (Services.Favorites.isFavorite(this.ingredientInfo.name())) {
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").withStyle(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").withStyle(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.itemGuide.open").withStyle(ChatFormatting.RED));
        return tooltip;
    }

    public Component getHoverName() {
        return Component.literal((String)this.ingredientInfo.name()).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(" " + this.getTierString(this.ingredientInfo.tier()))));
    }

    private String getTierString(int tier) {
        String tierString = IngredientTierFormatting.fromTierNum(tier).getTierString();
        if (tierString == null) {
            WynntilsMod.warn("Invalid ingredient tier for: " + this.ingredientInfo.name() + ": " + tier);
            return "";
        }
        return tierString;
    }

    private List<MutableComponent> generateGuideTooltip() {
        ArrayList<MutableComponent> itemLore = new ArrayList<MutableComponent>();
        itemLore.add(Component.literal((String)"Crafting Ingredient").withStyle(ChatFormatting.DARK_GRAY));
        itemLore.add(Component.empty());
        itemLore.addAll(this.getStatsLore(this.ingredientInfo));
        itemLore.addAll(this.getPositionModifierLore(this.ingredientInfo));
        itemLore.addAll(this.getEffectsAndRequirementsLore(this.ingredientInfo));
        itemLore.add(Component.literal((String)("Crafting Lv. Min: " + this.ingredientInfo.level())).withStyle(ChatFormatting.GRAY));
        for (ProfessionType profession : this.ingredientInfo.professions()) {
            itemLore.add(Component.literal((String)("  " + profession.getProfessionIconChar() + " ")).append((Component)Component.literal((String)profession.getDisplayName()).withStyle(ChatFormatting.GRAY)));
        }
        return itemLore;
    }

    private List<MutableComponent> getStatsLore(IngredientInfo ingredientInfo) {
        ArrayList<MutableComponent> itemLore = new ArrayList<MutableComponent>();
        for (Pair<StatType, RangedValue> valuedStat : ingredientInfo.variableStats()) {
            if (valuedStat.value().isFixed()) {
                if (valuedStat.value().low() >= 0) {
                    itemLore.add(Component.literal((String)("+" + valuedStat.value().low() + valuedStat.key().getUnit().getDisplayName())).withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)(" " + valuedStat.key().getDisplayName())).withStyle(ChatFormatting.GRAY)));
                    continue;
                }
                itemLore.add(Component.literal((String)(valuedStat.value().low() + valuedStat.key().getUnit().getDisplayName())).withStyle(ChatFormatting.RED).append((Component)Component.literal((String)(" " + valuedStat.key().getDisplayName())).withStyle(ChatFormatting.GRAY)));
                continue;
            }
            if (valuedStat.value().low() >= 0) {
                itemLore.add(Component.literal((String)("+" + valuedStat.value().low())).withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)" to ").withStyle(ChatFormatting.DARK_GREEN)).append((Component)Component.literal((String)(valuedStat.value().high() + valuedStat.key().getUnit().getDisplayName())).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)(" " + valuedStat.key().getDisplayName())).withStyle(ChatFormatting.GRAY)));
                continue;
            }
            itemLore.add(Component.literal((String)String.valueOf(valuedStat.value().low())).withStyle(ChatFormatting.RED).append((Component)Component.literal((String)" to ").withStyle(ChatFormatting.DARK_RED)).append((Component)Component.literal((String)(valuedStat.value().high() + valuedStat.key().getUnit().getDisplayName())).withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)(" " + valuedStat.key().getDisplayName())).withStyle(ChatFormatting.GRAY)));
        }
        if (!itemLore.isEmpty()) {
            itemLore.add(Component.empty());
        }
        return itemLore;
    }

    private List<MutableComponent> getPositionModifierLore(IngredientInfo ingredientInfo) {
        ArrayList<MutableComponent> itemLore = new ArrayList<MutableComponent>();
        for (Map.Entry<IngredientPosition, Integer> modifier : ingredientInfo.positionModifiers().entrySet()) {
            int value = modifier.getValue();
            Object colorCode = value > 0 ? String.valueOf(ChatFormatting.GREEN) + "+" : ChatFormatting.RED.toString();
            itemLore.add(Component.literal((String)((String)colorCode + value + "%" + String.valueOf(ChatFormatting.GRAY) + " Ingredient Effectiveness")));
            itemLore.add(Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "(To ingredients " + modifier.getKey().getDisplayName() + " this one)")));
        }
        if (!itemLore.isEmpty()) {
            itemLore.add(Component.empty());
        }
        return itemLore;
    }

    private List<MutableComponent> getEffectsAndRequirementsLore(IngredientInfo ingredientInfo) {
        ArrayList<MutableComponent> itemLore = new ArrayList<MutableComponent>();
        if (ingredientInfo.durabilityModifier() != 0 && ingredientInfo.duration() != 0) {
            int durability;
            duration = ingredientInfo.duration();
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Durability", durability, (durability = ingredientInfo.durabilityModifier()) > 0).append((Component)Component.literal((String)" or ").withStyle(ChatFormatting.GRAY)).append((Component)GuideIngredientItemStack.getEffectsAndRequirementsLine("Duration", duration, duration > 0)));
        } else if (ingredientInfo.durabilityModifier() != 0) {
            int durability;
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Durability", durability, (durability = ingredientInfo.durabilityModifier()) > 0));
        } else if (ingredientInfo.duration() != 0) {
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Duration", duration, (duration = ingredientInfo.duration()) > 0));
        }
        if (ingredientInfo.charges() != 0) {
            int charges;
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine("Charges", charges, (charges = ingredientInfo.charges()) > 0));
        }
        for (Pair<Skill, Integer> skillReq : ingredientInfo.skillRequirements()) {
            int minLevel = skillReq.value();
            itemLore.add(GuideIngredientItemStack.getEffectsAndRequirementsLine(skillReq.key().getDisplayName() + " Min.", minLevel, minLevel < 0));
        }
        if (!itemLore.isEmpty()) {
            itemLore.add(Component.empty());
        }
        return itemLore;
    }

    private static MutableComponent getEffectsAndRequirementsLine(String effectName, int value, boolean isGood) {
        return Component.literal((String)(StringUtils.toSignedString(value) + " " + effectName)).withStyle(isGood ? ChatFormatting.GREEN : ChatFormatting.RED);
    }

    public IngredientInfo getIngredientInfo() {
        return this.ingredientInfo;
    }
}

