/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.wynntils.core.components.Services;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.widgets.filters.GuideFilterButton;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.statproviders.ClassStatProvider;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;

public class ClassTypeFilterWidget
extends GuideFilterWidget {
    private final List<ClassTypeButton> classTypeButtons = new ArrayList<ClassTypeButton>();
    private ClassStatProvider provider;

    public ClassTypeFilterWidget(int x, int y, WynntilsGuideScreen guideScreen, ItemSearchQuery searchQuery) {
        super(x, y, 96, 16, guideScreen);
        this.classTypeButtons.add(new ClassTypeButton(x, y, ClassType.WARRIOR, Texture.SPEAR_FILTER_ICON, searchQuery));
        this.classTypeButtons.add(new ClassTypeButton(x + 20, y, ClassType.MAGE, Texture.WAND_FILTER_ICON, searchQuery));
        this.classTypeButtons.add(new ClassTypeButton(x + 40, y, ClassType.ASSASSIN, Texture.DAGGER_FILTER_ICON, searchQuery));
        this.classTypeButtons.add(new ClassTypeButton(x + 60, y, ClassType.ARCHER, Texture.BOW_FILTER_ICON, searchQuery));
        this.classTypeButtons.add(new ClassTypeButton(x + 80, y, ClassType.SHAMAN, Texture.RELIK_FILTER_ICON, searchQuery));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.classTypeButtons.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked = false;
        for (ClassTypeButton classTypeButton : this.classTypeButtons) {
            if (!classTypeButton.isMouseOver(mouseX, mouseY)) continue;
            clicked = classTypeButton.mouseClicked(mouseX, mouseY, button);
            break;
        }
        this.guideScreen.updateSearchFromQuickFilters();
        return clicked;
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        ArrayList<StatProviderAndFilterPair> filterPairs = new ArrayList<StatProviderAndFilterPair>();
        for (ClassTypeButton classTypeButton : this.classTypeButtons) {
            StatProviderAndFilterPair filterPair = classTypeButton.getFilterPair(this.provider);
            if (filterPair == null) continue;
            filterPairs.add(filterPair);
        }
        return filterPairs;
    }

    @Override
    public void getProvider() {
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(statProvider -> statProvider instanceof ClassStatProvider).map(statProvider -> (ClassStatProvider)statProvider).findFirst().orElseThrow(() -> new IllegalStateException("Could not get class stat provider"));
    }

    @Override
    public void updateFromQuery(ItemSearchQuery searchQuery) {
        this.classTypeButtons.forEach(classTypeButton -> classTypeButton.updateStateFromQuery(searchQuery));
    }

    private static class ClassTypeButton
    extends GuideFilterButton<ClassStatProvider> {
        private final ClassType classType;

        protected ClassTypeButton(int x, int y, ClassType classType, Texture texture, ItemSearchQuery searchQuery) {
            super(x, y, texture);
            this.classType = classType;
            this.updateStateFromQuery(searchQuery);
        }

        @Override
        protected void updateStateFromQuery(ItemSearchQuery searchQuery) {
            this.state = searchQuery.filters().values().stream().filter(filterPair -> filterPair.statProvider() instanceof ClassStatProvider).anyMatch(filterPair -> filterPair.statFilter().matches(EnumUtils.toNiceString(this.classType)));
        }

        @Override
        protected StatProviderAndFilterPair getFilterPair(ClassStatProvider provider) {
            if (!this.state) {
                return null;
            }
            Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create(this.classType.getName());
            return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(provider, (StatFilter<String>)stringStatFilter)).orElse(null);
        }

        @Override
        protected String getFilterName() {
            return I18n.get((String)"service.wynntils.itemFilter.stat.class.name", (Object[])new Object[0]) + " " + this.classType.getName();
        }
    }
}

