/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.itemfilter.widgets.FilterOptionsButton;
import com.wynntils.screens.itemfilter.widgets.PresetButton;
import com.wynntils.screens.itemfilter.widgets.ProviderButton;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.SortWidget;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class ItemFilterScreen
extends WynntilsScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int MAX_PRESETS = 4;
    private static final int MAX_PROVIDERS_PER_PAGE = 8;
    private static final int MAX_SORTS_PER_PAGE = 7;
    private static final int PROVIDER_MASK_TOP_Y = 25;
    private static final int PROVIDER_MASK_BOTTOM_Y = 197;
    private final List<ItemProviderType> supportedProviderTypes;
    private List<ItemStatProvider<?>> itemStatProviders = new ArrayList();
    private List<SortInfo> sorts = new ArrayList<SortInfo>();
    private List<Pair<String, String>> presets;
    private List<SortWidget> sortButtons = new ArrayList<SortWidget>();
    private List<WynntilsButton> presetButtons = new ArrayList<WynntilsButton>();
    private List<WynntilsButton> providerButtons = new ArrayList<WynntilsButton>();
    private Map<ItemStatProvider<?>, List<StatProviderAndFilterPair>> filterMap = new HashMap();
    private final SearchWidget itemSearchWidget;
    private final SearchWidget previousSearchWidget;
    private final SearchWidget providerSearchWidget;
    private final TextInputBoxWidget itemNameInput;
    private Button applyButton;
    private Button savePresetButton;
    private Button toggleSortButton;
    private FilterOptionsButton allButton;
    private FilterOptionsButton usedButton;
    private FilterOptionsButton unusedButton;
    private FilterOptionsButton selectedFilterButton;
    private ProviderFilterListWidget filterWidget;
    private TextInputBoxWidget focusedTextInput;
    private TextInputBoxWidget presetNameInput;
    private WynntilsButton nextPresetButton;
    private WynntilsButton previousPresetButton;
    private boolean draggingProviderScroll = false;
    private boolean draggingSortScroll = false;
    private float providerScrollY;
    private float sortScrollY;
    private int presetsScrollOffset = 0;
    private int providersScrollOffset = 0;
    private int sortScrollOffset = 0;
    private int offsetX;
    private int offsetY;
    private Renderable hovered = null;
    private final boolean supportsSorting;
    private final Screen previousScreen;
    private boolean sortMode = false;
    private FilterType filterType = FilterType.ALL;
    private ItemStatProvider<?> selectedProvider;

    private ItemFilterScreen(SearchWidget searchWidget, Screen previousScreen, boolean supportsSorting, List<ItemProviderType> supportedProviderTypes) {
        super((Component)Component.literal((String)"Item Filter Screen"));
        this.previousSearchWidget = searchWidget;
        this.previousScreen = previousScreen;
        this.supportsSorting = supportsSorting;
        this.supportedProviderTypes = supportedProviderTypes;
        this.itemNameInput = new TextInputBoxWidget(220, 5, 100, 18, s -> this.updateQueryString(), this);
        this.providerSearchWidget = new SearchWidget(7, 5, supportsSorting ? 100 : 120, 20, s -> {
            this.providersScrollOffset = 0;
            this.updateProviderWidgets();
        }, this);
        this.itemSearchWidget = new ItemSearchWidget(0, -22, Texture.ITEM_FILTER_BACKGROUND.width() - 40, 20, supportedProviderTypes, supportsSorting, query -> {
            if (this.applyButton == null) {
                return;
            }
            this.applyButton.active = true;
        }, this);
        this.itemSearchWidget.setTextBoxInput(this.previousSearchWidget.getTextBoxInput());
        this.setFocusedTextInput(this.providerSearchWidget);
        this.presets = (List)Services.ItemFilter.presets.get();
    }

    public static Screen create(SearchWidget searchWidget, Screen previousScreen, boolean supportsSorting, List<ItemProviderType> supportedProviderTypes) {
        return new ItemFilterScreen(searchWidget, previousScreen, supportsSorting, supportedProviderTypes);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.width - Texture.ITEM_FILTER_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.ITEM_FILTER_BACKGROUND.height()) / 2.0f);
        this.itemNameInput.setX(220 + this.offsetX);
        this.itemNameInput.setY(5 + this.offsetY);
        this.providerSearchWidget.setX(7 + this.offsetX);
        this.providerSearchWidget.setY(5 + this.offsetY);
        this.itemSearchWidget.setX(this.offsetX);
        this.itemSearchWidget.setY(-22 + this.offsetY);
        this.addRenderableWidget((GuiEventListener)this.itemSearchWidget);
        this.addRenderableWidget((GuiEventListener)this.providerSearchWidget);
        this.addRenderableWidget((GuiEventListener)this.itemNameInput);
        this.presetNameInput = new TextInputBoxWidget(220 + this.offsetX, 180 + this.offsetY, 100, 20, s -> this.checkSaveStatus(), this, this.presetNameInput);
        this.addRenderableWidget((GuiEventListener)this.presetNameInput);
        if (this.supportsSorting) {
            this.toggleSortButton = new Button.Builder((Component)Component.literal((String)(this.sortMode ? "\ud83d\udd0d" : "\u21c5")), button -> this.toggleSortMode()).pos(108 + this.offsetX, 5 + this.offsetY).size(20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)(this.sortMode ? "screens.wynntils.itemFilter.filterToggle" : "screens.wynntils.itemFilter.sortToggle")))).build();
            this.addRenderableWidget((GuiEventListener)this.toggleSortButton);
        }
        Button returnButton = new Button.Builder((Component)Component.literal((String)"\u23ce"), button -> this.onClose()).pos(Texture.ITEM_FILTER_BACKGROUND.width() - 18 + this.offsetX, -22 + this.offsetY).size(20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.itemFilter.return"))).build();
        this.addRenderableWidget((GuiEventListener)returnButton);
        boolean activeApply = this.applyButton != null && this.applyButton.active;
        this.applyButton = new Button.Builder((Component)Component.literal((String)"\u2714").withStyle(ChatFormatting.GREEN), button -> {
            this.providersScrollOffset = 0;
            this.sortScrollOffset = 0;
            this.updateStateFromItemSearchWidget();
            this.applyButton.active = false;
        }).pos(Texture.ITEM_FILTER_BACKGROUND.width() - 39 + this.offsetX, -22 + this.offsetY).size(20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.itemFilter.apply"))).build();
        this.applyButton.active = activeApply;
        this.addRenderableWidget((GuiEventListener)this.applyButton);
        this.savePresetButton = new Button.Builder((Component)Component.literal((String)"\ud83d\udcbe"), button -> this.savePreset()).pos(330 + this.offsetX, 180 + this.offsetY).size(20, 20).build();
        this.savePresetButton.active = !this.presetNameInput.getTextBoxInput().isEmpty() && !this.itemSearchWidget.getTextBoxInput().isEmpty();
        this.addRenderableWidget((GuiEventListener)this.savePresetButton);
        this.previousPresetButton = (WynntilsButton)this.addRenderableWidget((GuiEventListener)new PresetButton(Texture.ITEM_FILTER_BACKGROUND.width() - 4 + this.offsetX, 4 + this.offsetY, StyledText.fromString("\ud83e\udc1d"), b -> this.scrollPresets(-1), List.of(Component.translatable((String)"screens.wynntils.itemFilter.scrollUp")), this.offsetX, this.offsetY));
        this.nextPresetButton = (WynntilsButton)this.addRenderableWidget((GuiEventListener)new PresetButton(Texture.ITEM_FILTER_BACKGROUND.width() - 4 + this.offsetX, 174 + this.offsetY, StyledText.fromString("\ud83e\udc1f"), b -> this.scrollPresets(1), List.of(Component.translatable((String)"screens.wynntils.itemFilter.scrollDown")), this.offsetX, this.offsetY));
        if (this.presets.size() <= 4) {
            this.previousPresetButton.visible = false;
            this.nextPresetButton.visible = false;
        }
        this.allButton = new FilterOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 8 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.allFilter")), button -> this.setSelectedFilter(FilterType.ALL), List.of(Component.translatable((String)"screens.wynntils.itemFilter.allFilterTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.ALL, this.offsetX, this.offsetY);
        this.usedButton = new FilterOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 12 + Texture.BUTTON_LEFT.height() / 2 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.usedFilter")), button -> this.setSelectedFilter(FilterType.USED), List.of(Component.translatable((String)"screens.wynntils.itemFilter.usedFilterTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.USED, this.offsetX, this.offsetY);
        this.unusedButton = new FilterOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 16 + Texture.BUTTON_LEFT.height() / 2 * 2 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.unusedFilter")), button -> this.setSelectedFilter(FilterType.UNUSED), List.of(Component.translatable((String)"screens.wynntils.itemFilter.unusedFilterTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.UNUSED, this.offsetX, this.offsetY);
        switch (this.filterType.ordinal()) {
            case 1: {
                this.selectedFilterButton = this.usedButton;
                break;
            }
            case 2: {
                this.selectedFilterButton = this.unusedButton;
                break;
            }
            default: {
                this.selectedFilterButton = this.allButton;
            }
        }
        this.addRenderableWidget((GuiEventListener)this.allButton);
        this.addRenderableWidget((GuiEventListener)this.usedButton);
        this.addRenderableWidget((GuiEventListener)this.unusedButton);
        this.filterWidget = null;
        this.updateProviderWidgets();
        this.updatePresetWidgets();
        this.updateStateFromItemSearchWidget();
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WynntilsButton wynntilsButton;
        PoseStack poseStack = guiGraphics.pose();
        this.hovered = null;
        RenderUtils.drawTexturedRect(poseStack, Texture.ITEM_FILTER_BACKGROUND, this.offsetX, this.offsetY);
        if (this.selectedProvider == null && !this.sortMode) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.unselectedFilter")), 147 + this.offsetX, 345 + this.offsetX, 63 + this.offsetY, 123 + this.offsetY, 200.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        } else if (this.sortMode && this.sorts.isEmpty()) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.noSorts")), 147 + this.offsetX, 345 + this.offsetX, 63 + this.offsetY, 123 + this.offsetY, 200.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        if (!this.sortMode) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.itemName")), 150 + this.offsetX, 10 + this.offsetY, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.presetName")), 150 + this.offsetX, 185 + this.offsetY, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            if (!(renderable instanceof WynntilsButton) || !(wynntilsButton = (WynntilsButton)renderable).isMouseOver(mouseX, mouseY)) continue;
            this.hovered = renderable;
        }
        if (this.providerButtons.isEmpty()) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.noProviders")), 8 + this.offsetX, 127 + this.offsetX, 28 + this.offsetY, 169 + this.offsetY, 118.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        } else {
            RenderUtils.enableScissor(guiGraphics, 6 + this.offsetX, 28 + this.offsetY, 122, 170);
            for (Renderable renderable : this.providerButtons) {
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            RenderUtils.disableScissor(guiGraphics);
        }
        RenderUtils.enableScissor(guiGraphics, 149 + this.offsetX, 28 + this.offsetY, 172, 149);
        for (Renderable renderable : this.sortButtons) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        for (Renderable renderable : this.presetButtons) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            if (!(renderable instanceof WynntilsButton) || !(wynntilsButton = (WynntilsButton)renderable).isMouseOver(mouseX, mouseY)) continue;
            this.hovered = renderable;
        }
        if (this.itemStatProviders.size() > 8) {
            this.renderProvidersScroll(poseStack);
        }
        if (this.sortMode && this.sorts.size() > 7) {
            this.renderSortScroll(poseStack);
        }
        this.renderTooltips(guiGraphics, mouseX, mouseY);
    }

    public void added() {
        this.providerSearchWidget.opened();
        super.added();
    }

    public void onClose() {
        this.previousSearchWidget.setTextBoxInput(this.itemSearchWidget.getTextBoxInput());
        McUtils.setScreen(this.previousScreen);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingProviderScroll && this.itemStatProviders.size() > 8 && MathUtils.isInside((int)mouseX, (int)mouseY, 133 + this.offsetX, 133 + Texture.SCROLL_BUTTON.width() + this.offsetX, (int)this.providerScrollY, (int)(this.providerScrollY + (float)Texture.SCROLL_BUTTON.height()))) {
            this.draggingProviderScroll = true;
            return true;
        }
        if (this.sortMode && !this.draggingSortScroll && this.sorts.size() > 7 && MathUtils.isInside((int)mouseX, (int)mouseY, 330, 336, (int)this.sortScrollY, (int)(this.sortScrollY + 20.0f))) {
            this.draggingSortScroll = true;
            return true;
        }
        for (GuiEventListener listener : this.getWidgetsForIteration().toList()) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            if ((listener instanceof PresetButton || listener instanceof FilterOptionsButton) && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX, Texture.ITEM_FILTER_BACKGROUND.width() + this.offsetX, this.offsetY, Texture.ITEM_FILTER_BACKGROUND.height() + this.offsetY)) {
                return false;
            }
            listener.mouseClicked(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.filterWidget != null && !this.filterWidget.isMouseOver(mouseX, mouseY)) {
            this.filterWidget.mouseReleased(mouseX, mouseY, button);
        }
        if (this.draggingProviderScroll) {
            int scrollAreaStartY = 34 + this.offsetY;
            int scrollAreaHeight = 168 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxProviderScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxProviderScrollOffset()));
            this.scrollProviders(newOffset);
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.draggingSortScroll) {
            int scrollAreaStartY = 40;
            int scrollAreaHeight = 127;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxSortsScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxSortsScrollOffset()));
            this.scrollSorts(newOffset);
            return true;
        }
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingProviderScroll = false;
        this.draggingSortScroll = false;
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY)) continue;
            return listener.mouseReleased(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        for (GuiEventListener listener : this.children) {
            if (!listener.isMouseOver(mouseX, mouseY) || !listener.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) continue;
            return true;
        }
        if (this.presets.size() > 4 && mouseX >= (double)(Texture.ITEM_FILTER_BACKGROUND.width() + this.offsetX)) {
            this.scrollPresets((int)scrollValue);
            return true;
        }
        int scrollAmount = (int)(-deltaY * 10.0);
        if (this.sortMode && mouseX >= (double)(150 + this.offsetX)) {
            int newOffset = Math.max(0, Math.min(this.sortScrollOffset + scrollAmount, this.getMaxSortsScrollOffset()));
            this.scrollSorts(newOffset);
        } else {
            int newOffset = Math.max(0, Math.min(this.providersScrollOffset + scrollAmount, this.getMaxProviderScrollOffset()));
            this.scrollProviders(newOffset);
        }
        return true;
    }

    @Override
    public boolean charTyped(char codePoint, int modifiers) {
        return this.focusedTextInput != null && this.focusedTextInput.charTyped(codePoint, modifiers);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (keyCode == 257 && this.applyButton.active) {
            this.updateStateFromItemSearchWidget();
            this.applyButton.active = false;
        }
        return this.focusedTextInput != null && this.focusedTextInput.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.focusedTextInput;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.focusedTextInput = focusedTextInput;
    }

    public void setFiltersForProvider(ItemStatProvider<?> provider, List<StatProviderAndFilterPair> filterPairs) {
        this.filterMap.remove(provider);
        if (filterPairs != null && !filterPairs.isEmpty()) {
            this.filterMap.put(provider, filterPairs);
        }
        this.updateQueryString();
    }

    public void updateFilterWidget() {
        if (this.filterWidget != null && this.selectedProvider != null) {
            this.filterWidget.onFiltersChanged(this.filterMap.getOrDefault(this.selectedProvider, List.of()));
        }
    }

    public void addSort(SortInfo newSort) {
        this.sorts = this.sorts.stream().filter(sort -> sort.provider() != newSort.provider()).collect(Collectors.toList());
        this.sorts.add(newSort);
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public void removeSort(ItemStatProvider<?> provider) {
        this.sorts.removeIf(sort -> sort.provider() == provider);
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public void changeSort(SortInfo oldSortInfo, SortInfo newSortInfo) {
        this.sorts = this.sorts.stream().map(sort -> {
            if (sort.equals(oldSortInfo)) {
                return newSortInfo;
            }
            return sort;
        }).collect(Collectors.toList());
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public void reorderSort(SortInfo sortInfo, int direction) {
        int indexOf = this.sorts.indexOf(sortInfo);
        if (indexOf == -1) {
            return;
        }
        SortInfo sort = this.sorts.get(indexOf);
        this.sorts.remove(sort);
        this.sorts.add(indexOf + direction, sort);
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public boolean inSortMode() {
        return this.sortMode;
    }

    public Pair<Boolean, Boolean> canSortMove(SortInfo sortInfo) {
        int index = this.sorts.indexOf(sortInfo);
        return Pair.of(index != 0, index != this.sorts.size() - 1);
    }

    public void setSelectedProvider(ItemStatProvider<?> selectedProvider) {
        this.selectedProvider = selectedProvider;
        this.createValueWidget();
    }

    public ItemStatProvider<?> getSelectedProvider() {
        return this.selectedProvider;
    }

    public boolean isProviderInUse(ItemStatProvider<?> provider) {
        return this.filterMap.containsKey(provider) || this.sorts.stream().anyMatch(sort -> sort.provider() == provider);
    }

    public int getProviderMaskTopY() {
        return 25 + this.offsetY;
    }

    public int getProviderMaskBottomY() {
        return 197 + this.offsetY;
    }

    private void updateProviderWidgets() {
        for (AbstractWidget abstractWidget : this.providerButtons) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        this.providerButtons = new ArrayList<WynntilsButton>();
        this.itemStatProviders = Services.ItemFilter.getItemStatProviders().stream().filter(itemStatProvider -> itemStatProvider.getFilterTypes().stream().anyMatch(this.supportedProviderTypes::contains)).filter(provider -> this.searchMatches(provider.getDisplayName())).toList();
        if (this.filterType == FilterType.USED) {
            this.itemStatProviders = this.itemStatProviders.stream().filter(this::isProviderInUse).toList();
        } else if (this.filterType == FilterType.UNUSED) {
            this.itemStatProviders = this.itemStatProviders.stream().filter(provider -> !this.isProviderInUse((ItemStatProvider<?>)provider)).toList();
        }
        int yPos = 31 + this.offsetY;
        for (ItemStatProvider<?> itemStatProvider2 : this.itemStatProviders) {
            this.providerButtons.add(new ProviderButton(7 + this.offsetX, yPos, 120, 18, this, itemStatProvider2));
            yPos += 21;
        }
        if (this.selectedProvider != null) {
            Stream stream = Services.ItemFilter.getItemStatProviders().stream();
            ItemStatProvider itemStatProvider3 = stream.filter(provider -> provider.getName().equals(this.selectedProvider.getName())).findFirst().orElse(null);
            this.setSelectedProvider(itemStatProvider3);
        }
        this.scrollProviders(this.providersScrollOffset);
    }

    private void updateStateFromItemSearchWidget() {
        this.parseFilters();
        this.updateProviderWidgets();
        if (this.sortMode) {
            this.updateSortWidgets();
        }
        this.updateFilterWidget();
    }

    /*
     * WARNING - void declaration
     */
    private void updatePresetWidgets() {
        void var2_5;
        for (AbstractWidget abstractWidget : this.presetButtons) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        this.presetButtons = new ArrayList<WynntilsButton>();
        if (this.presets.isEmpty()) {
            return;
        }
        int yPos = 4 + this.offsetY;
        boolean bl = false;
        while (var2_5 < Math.min(4, this.presets.size())) {
            yPos += Texture.BUTTON_RIGHT.height() / 2 + 6;
            void presetIndex = var2_5 + this.presetsScrollOffset < 0 ? var2_5 + this.presetsScrollOffset + this.presets.size() : (var2_5 + this.presetsScrollOffset > this.presets.size() - 1 ? var2_5 + this.presetsScrollOffset - this.presets.size() : var2_5 + this.presetsScrollOffset);
            if (presetIndex > this.presets.size() - 1) break;
            String presetName = this.presets.get((int)presetIndex).a();
            List<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)Component.literal((String)presetName));
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.itemFilter.presetHelp1"));
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.itemFilter.presetHelp2"));
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.itemFilter.presetHelp3"));
            tooltip.add((Component)Component.translatable((String)"screens.wynntils.itemFilter.presetHelp4"));
            tooltip = ComponentUtils.wrapTooltips(tooltip, 200);
            this.presetButtons.add(new PresetButton(Texture.ITEM_FILTER_BACKGROUND.width() - 4 + this.offsetX, yPos, StyledText.fromString(presetName), arg_0 -> this.lambda$updatePresetWidgets$21((int)presetIndex, arg_0), tooltip, this.offsetX, this.offsetY));
            ++var2_5;
        }
    }

    private void updateSortWidgets() {
        for (AbstractWidget abstractWidget : this.sortButtons) {
            this.removeWidget((GuiEventListener)abstractWidget);
        }
        this.sortButtons = new ArrayList<SortWidget>();
        int yPos = 29 + this.offsetY;
        for (SortInfo sort : this.sorts) {
            this.sortButtons.add(new SortWidget(150 + this.offsetX, yPos, this, sort));
            yPos += 21;
        }
        this.scrollSorts(this.sortScrollOffset);
    }

    private void createValueWidget() {
        if (this.filterWidget != null) {
            this.removeWidget((GuiEventListener)this.filterWidget);
        }
        this.filterWidget = new ProviderFilterListWidget(150 + this.offsetX, 30 + this.offsetY, this, this.selectedProvider, this.filterMap.getOrDefault(this.selectedProvider, List.of()));
        this.addRenderableWidget((GuiEventListener)this.filterWidget);
    }

    private void scrollProviders(int newOffset) {
        this.providersScrollOffset = newOffset;
        for (WynntilsButton provider : this.providerButtons) {
            int newY = 31 + this.offsetY + this.providerButtons.indexOf((Object)provider) * 21 - this.providersScrollOffset;
            provider.setY(newY);
            provider.visible = newY >= 31 + this.offsetY - 21 && newY <= 31 + this.offsetY + 189;
        }
    }

    private void scrollSorts(int newOffset) {
        this.sortScrollOffset = newOffset;
        for (SortWidget sort : this.sortButtons) {
            int newY = 31 + this.offsetY + this.sortButtons.indexOf((Object)sort) * 21 - this.sortScrollOffset;
            sort.setY(newY);
            sort.visible = newY >= 31 + this.offsetY - 21 && newY <= 31 + this.offsetY + 168;
        }
    }

    private void scrollPresets(int direction) {
        this.presetsScrollOffset = Math.abs(this.presetsScrollOffset + direction) == this.presets.size() ? 0 : MathUtils.clamp(this.presetsScrollOffset + direction, -(this.presets.size() - 1), this.presets.size() - 1);
        this.updatePresetWidgets();
    }

    private int getMaxProviderScrollOffset() {
        return (this.itemStatProviders.size() - 8) * 21;
    }

    private int getMaxSortsScrollOffset() {
        return (this.sorts.size() - 7) * 21;
    }

    private void clickPreset(int button, int presetIndex) {
        if (button == 0) {
            if (KeyboardUtils.isShiftDown()) {
                int indexToSwap = presetIndex == 0 ? this.presets.size() - 1 : presetIndex - 1;
                Collections.swap(this.presets, presetIndex, indexToSwap);
                Services.ItemFilter.presets.store(this.presets);
                Services.ItemFilter.presets.touched();
                this.presets = (List)Services.ItemFilter.presets.get();
                this.updatePresetWidgets();
            } else {
                this.itemSearchWidget.setTextBoxInput(this.presets.get(presetIndex).b());
                this.updateStateFromItemSearchWidget();
            }
        } else if (button == 1) {
            if (KeyboardUtils.isShiftDown()) {
                int indexToSwap = presetIndex == this.presets.size() - 1 ? 0 : presetIndex + 1;
                Collections.swap(this.presets, presetIndex, indexToSwap);
                Services.ItemFilter.presets.store(this.presets);
                Services.ItemFilter.presets.touched();
                this.presets = (List)Services.ItemFilter.presets.get();
                this.updatePresetWidgets();
            } else if (KeyboardUtils.isControlDown()) {
                this.presets.remove(presetIndex);
                Services.ItemFilter.presets.store(this.presets);
                Services.ItemFilter.presets.touched();
                this.presets = (List)Services.ItemFilter.presets.get();
                this.presetsScrollOffset = Math.max(this.presetsScrollOffset - 1, 0);
                this.updatePresetWidgets();
                if (this.presets.size() <= 4) {
                    this.nextPresetButton.visible = false;
                    this.previousPresetButton.visible = false;
                }
            }
        }
    }

    private void savePreset() {
        this.presets.add(new Pair<String, String>(this.presetNameInput.getTextBoxInput(), this.itemSearchWidget.getTextBoxInput()));
        Services.ItemFilter.presets.store(this.presets);
        Services.ItemFilter.presets.touched();
        this.presetNameInput.setTextBoxInput("");
        if (this.presets.size() > 4) {
            this.nextPresetButton.visible = true;
            this.previousPresetButton.visible = true;
        }
        this.updatePresetWidgets();
    }

    private void checkSaveStatus() {
        if (this.presetNameInput == null || this.itemSearchWidget == null) {
            return;
        }
        this.savePresetButton.active = !this.presetNameInput.getTextBoxInput().isEmpty() && !this.itemSearchWidget.getTextBoxInput().isEmpty();
    }

    private void toggleSortMode() {
        this.sortMode = !this.sortMode;
        boolean bl = this.itemNameInput.visible = !this.sortMode;
        if (this.sortMode) {
            if (this.filterWidget != null) {
                this.selectedProvider = null;
                this.removeWidget((GuiEventListener)this.filterWidget);
            }
            this.sortScrollOffset = 0;
            this.updateSortWidgets();
        } else {
            for (AbstractWidget abstractWidget : this.sortButtons) {
                this.removeWidget((GuiEventListener)abstractWidget);
            }
            this.sortButtons = new ArrayList<SortWidget>();
        }
        this.toggleSortButton.setMessage((Component)Component.literal((String)(this.sortMode ? "\ud83d\udd0d" : "\u21c5")));
        this.toggleSortButton.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.sortMode ? "screens.wynntils.itemFilter.filterToggle" : "screens.wynntils.itemFilter.sortToggle"))));
    }

    private void parseFilters() {
        ItemSearchQuery searchQuery = Services.ItemFilter.createSearchQuery(this.itemSearchWidget.getTextBoxInput(), true, this.supportedProviderTypes);
        this.filterMap = new HashMap(searchQuery.filters().entries());
        this.sorts = searchQuery.sorts();
        String plainTextString = String.join((CharSequence)" ", searchQuery.plainTextTokens());
        if (plainTextString.equals(this.itemNameInput.getTextBoxInput())) {
            return;
        }
        this.itemNameInput.setTextBoxInput(plainTextString);
    }

    private void updateQueryString() {
        String queryString = Services.ItemFilter.getItemFilterString(this.filterMap, this.sorts, List.of(this.itemNameInput.getTextBoxInput()));
        if (Objects.equals(this.itemSearchWidget.getTextBoxInput(), queryString)) {
            return;
        }
        this.itemSearchWidget.setTextBoxInput(queryString);
        if (this.applyButton != null) {
            this.applyButton.active = false;
        }
        this.savePresetButton.active = !this.presetNameInput.getTextBoxInput().isEmpty() && !this.itemSearchWidget.getTextBoxInput().isEmpty();
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if ((this.hovered instanceof PresetButton || this.hovered instanceof FilterOptionsButton) && MathUtils.isInside(mouseX, mouseY, this.offsetX, Texture.ITEM_FILTER_BACKGROUND.width() + this.offsetX, this.offsetY, Texture.ITEM_FILTER_BACKGROUND.height() + this.offsetY)) {
            return;
        }
        List<Object> tooltipLines = List.of();
        Renderable renderable = this.hovered;
        if (renderable instanceof TooltipProvider) {
            TooltipProvider tooltipWidget = (TooltipProvider)renderable;
            tooltipLines = tooltipWidget.getTooltipLines();
        }
        if (tooltipLines.isEmpty()) {
            return;
        }
        guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipLines, mouseX, mouseY);
    }

    private void renderProvidersScroll(PoseStack poseStack) {
        this.providerScrollY = (float)(24 + this.offsetY) + MathUtils.map(this.providersScrollOffset, 0.0f, this.getMaxProviderScrollOffset(), 0.0f, 177 - Texture.CONFIG_BOOK_SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BUTTON, 133 + this.offsetX, this.providerScrollY);
    }

    private void renderSortScroll(PoseStack poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, 330 + this.offsetX, 30 + this.offsetY, 0.0f, 6.0f, 147.0f);
        this.sortScrollY = (float)(30 + this.offsetY) + MathUtils.map(this.sortScrollOffset, 0.0f, this.getMaxSortsScrollOffset(), 0.0f, 127.0f);
        RenderUtils.drawRect(poseStack, this.draggingSortScroll ? CommonColors.BLACK : CommonColors.GRAY, 330 + this.offsetX, this.sortScrollY, 0.0f, 6.0f, 20.0f);
    }

    private void setSelectedFilter(FilterType newFilter) {
        this.selectedFilterButton.setIsSelected(false);
        switch (newFilter.ordinal()) {
            case 1: {
                this.usedButton.setIsSelected(true);
                this.selectedFilterButton = this.usedButton;
                break;
            }
            case 2: {
                this.unusedButton.setIsSelected(true);
                this.selectedFilterButton = this.unusedButton;
                break;
            }
            default: {
                this.allButton.setIsSelected(true);
                this.selectedFilterButton = this.allButton;
            }
        }
        this.filterType = newFilter;
        this.providersScrollOffset = 0;
        this.updateProviderWidgets();
    }

    private boolean searchMatches(String name) {
        return StringUtils.partialMatch(name, this.providerSearchWidget.getTextBoxInput());
    }

    private Stream<GuiEventListener> getWidgetsForIteration() {
        return Stream.concat(this.children.stream(), Stream.concat(this.providerButtons.stream(), Stream.concat(this.sortButtons.stream(), this.presetButtons.stream())));
    }

    private static enum FilterType {
        ALL,
        USED,
        UNUSED;

    }
}

