/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.type.NumericFilterWidgetFactory;
import com.wynntils.screens.itemfilter.widgets.AnyFilterWidget;
import com.wynntils.screens.itemfilter.widgets.BooleanFilterWidget;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.SelectionFilterWidget;
import com.wynntils.screens.itemfilter.widgets.StringFilterWidget;
import com.wynntils.services.itemfilter.filters.AnyStatFilters;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.EnumUtils;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ProviderFilterListWidget
extends AbstractWidget {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int MAX_WIDGETS_PER_PAGE = 5;
    private static final int MAX_SELECTION_WIDGETS_PER_PAGE = 6;
    private static final int SCROLLBAR_HEIGHT = 20;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_RENDER_X = 184;
    private final ItemFilterScreen filterScreen;
    private final ItemStatProvider<?> provider;
    private boolean draggingScroll = false;
    private Button addNumericFilterButton;
    private Button addStringFilterButton;
    private Button numericChoiceButton;
    private int scrollOffset = 0;
    private int scrollRenderY;
    private List<GeneralFilterWidget> widgets = new ArrayList<GeneralFilterWidget>();
    private List<StatProviderAndFilterPair> filterPairs;
    private NumericType numericChoice = NumericType.SINGLE;

    public ProviderFilterListWidget(int x, int y, ItemFilterScreen filterScreen, ItemStatProvider<?> provider, List<StatProviderAndFilterPair> filterPairs) {
        super(x, y, 195, 145, (Component)Component.literal((String)"Provider Filter List Widget"));
        this.filterScreen = filterScreen;
        this.provider = provider;
        this.filterPairs = new ArrayList<StatProviderAndFilterPair>(filterPairs);
        if (provider.getType().equals(String.class) && provider.getValidInputs().isEmpty()) {
            this.addStringFilterButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.itemFilter.addNewFilter"), button -> {
                int renderY = this.widgets.isEmpty() ? this.getY() + 2 : this.widgets.getLast().getY() + 24;
                this.widgets.add(new StringFilterWidget(this.getX() + 5, renderY, 175, 20, null, this, filterScreen));
                if (this.isScrollable()) {
                    this.scroll(this.scrollOffset + 24);
                }
                this.addStringFilterButton.active = false;
            }).pos(this.getX() + 55, this.getY() + 125).size(85, 20).build();
        } else if (!provider.getType().equals(Boolean.class) && !provider.getType().equals(String.class)) {
            this.numericChoiceButton = new Button.Builder((Component)Component.literal((String)EnumUtils.toNiceString(this.numericChoice)), null).pos(this.getX(), this.getY() + 125).size(85, 20).build();
            this.addNumericFilterButton = new Button.Builder((Component)Component.translatable((String)"screens.wynntils.itemFilter.addNewFilter"), button -> {
                int renderY = this.widgets.isEmpty() ? this.getY() + 2 : this.widgets.getLast().getY() + 24;
                GeneralFilterWidget filterWidget = this.getNumericFilterWidget(renderY);
                if (filterWidget == null) {
                    return;
                }
                this.widgets.add(filterWidget);
                if (this.isScrollable()) {
                    this.scroll(this.scrollOffset + 24);
                }
                this.addNumericFilterButton.active = false;
            }).pos(this.getX() + 95, this.getY() + 125).size(85, 20).build();
        }
        this.createWidgets();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.addStringFilterButton != null) {
            this.addStringFilterButton.render(guiGraphics, mouseX, mouseY, partialTick);
        } else if (this.addNumericFilterButton != null) {
            this.addNumericFilterButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.numericChoiceButton.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.widgets.isEmpty()) {
            FontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.pose(), StyledText.fromComponent((Component)Component.translatable((String)"screens.wynntils.itemFilter.noFilters")), this.getX(), this.getX() + this.getWidth(), this.getY(), (float)this.getY() + this.getScrollableArea(), 180.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
            return;
        }
        RenderUtils.enableScissor(guiGraphics, this.getX(), this.getY() - 2, this.getWidth(), (int)(this.getScrollbarHeight() + 5.0f));
        for (GeneralFilterWidget widget : this.widgets) {
            widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        if (this.isScrollable()) {
            this.renderScrollBar(guiGraphics.pose());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.addStringFilterButton != null && this.addStringFilterButton.isMouseOver(mouseX, mouseY)) {
            return this.addStringFilterButton.mouseClicked(mouseX, mouseY, button);
        }
        if (this.addNumericFilterButton != null && this.addNumericFilterButton.isMouseOver(mouseX, mouseY)) {
            return this.addNumericFilterButton.mouseClicked(mouseX, mouseY, button);
        }
        if (this.numericChoiceButton != null && this.numericChoiceButton.isMouseOver(mouseX, mouseY)) {
            if (button == 0) {
                this.cycleNumericChoice(1);
                return true;
            }
            if (button == 1) {
                this.cycleNumericChoice(-1);
                return true;
            }
            return false;
        }
        if (mouseY > (double)(this.getY() + 2) && mouseY < (double)((float)(this.getY() + 2) + this.getScrollbarHeight())) {
            for (GeneralFilterWidget widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                return widget.mouseClicked(mouseX, mouseY, button);
            }
        }
        if (!this.draggingScroll && this.isScrollable() && MathUtils.isInside((int)mouseX, (int)mouseY, this.getX() + 184, this.getX() + 184 + 6, this.scrollRenderY, this.scrollRenderY + 20)) {
            this.draggingScroll = true;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.getY();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, (float)scrollAreaStartY + this.getScrollbarHeight(), 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        if (mouseY > (double)(this.getY() + 2) && mouseY < (double)((float)(this.getY() + 2) + this.getScrollbarHeight())) {
            for (GeneralFilterWidget widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                return widget.mouseReleased(mouseX, mouseY, button);
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isScrollable()) {
            int scrollAmount = (int)(-deltaY * 10.0);
            int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        return false;
    }

    public void createWidgets() {
        this.widgets = new ArrayList<GeneralFilterWidget>();
        if (!this.filterPairs.isEmpty()) {
            for (StatProviderAndFilterPair filterPair : this.filterPairs) {
                if (!(filterPair.statFilter() instanceof AnyStatFilters.AbstractAnyStatFilter)) continue;
                this.widgets.add(new AnyFilterWidget(this.getX(), this.getY(), this));
                if (this.addStringFilterButton != null) {
                    this.addStringFilterButton.visible = false;
                } else if (this.addNumericFilterButton != null) {
                    this.addNumericFilterButton.visible = false;
                    this.numericChoiceButton.visible = false;
                }
                return;
            }
        }
        if (this.provider.getType().equals(Boolean.class)) {
            if (this.filterPairs.isEmpty()) {
                this.widgets.add(new BooleanFilterWidget(this.getX(), this.getY(), null, this));
            } else {
                this.widgets.add(new BooleanFilterWidget(this.getX(), this.getY(), this.filterPairs.getFirst(), this));
            }
            return;
        }
        if (!this.provider.getValidInputs().isEmpty()) {
            int renderY = this.getY() + 2;
            for (int i = 0; i < this.provider.getValidInputs().size(); ++i) {
                String valueName = this.provider.getValidInputs().get(i);
                Optional<StatProviderAndFilterPair> filterPair = this.filterPairs.stream().filter(filter -> filter.statFilter().asString().equalsIgnoreCase(valueName)).findFirst();
                SelectionFilterWidget filterWidget = new SelectionFilterWidget(this.getX() + 5, renderY, 150, 20, valueName, filterPair, this);
                this.widgets.add(filterWidget);
                renderY += 24;
            }
            this.scroll(this.scrollOffset);
            return;
        }
        int renderY = this.getY() + 2;
        for (StatProviderAndFilterPair filterPair : this.filterPairs) {
            GeneralFilterWidget filterWidget = filterPair.statProvider().getType().equals(String.class) ? new StringFilterWidget(this.getX() + 5, renderY, 175, 20, filterPair, this, this.filterScreen) : NumericFilterWidgetFactory.createFilterWidget(this.provider.getType(), this.getX() + 5, renderY, 175, 20, filterPair, this, this.filterScreen);
            if (filterWidget == null) continue;
            this.widgets.add(filterWidget);
            renderY += 24;
        }
        if (this.provider.getType().equals(String.class)) {
            this.addStringFilterButton.visible = true;
            this.addStringFilterButton.active = true;
        } else if (!this.provider.getType().equals(Boolean.class)) {
            this.addNumericFilterButton.visible = true;
            this.addNumericFilterButton.active = true;
            this.numericChoiceButton.visible = true;
            this.numericChoiceButton.active = true;
        }
        this.scroll(this.scrollOffset);
    }

    public final void onFiltersChanged(List<StatProviderAndFilterPair> filterPairs) {
        this.filterPairs = new ArrayList<StatProviderAndFilterPair>(filterPairs);
        this.createWidgets();
    }

    public void updateQuery() {
        ArrayList<StatProviderAndFilterPair> newFilterpairs = new ArrayList<StatProviderAndFilterPair>();
        for (GeneralFilterWidget filterWidget : this.widgets) {
            newFilterpairs.add(filterWidget.getFilterPair());
        }
        this.filterPairs = new ArrayList<StatProviderAndFilterPair>(newFilterpairs.stream().filter(Objects::nonNull).toList());
        if (this.addStringFilterButton != null) {
            this.addStringFilterButton.active = this.filterPairs.size() == newFilterpairs.size();
        } else if (this.addNumericFilterButton != null) {
            this.addNumericFilterButton.active = this.filterPairs.size() == newFilterpairs.size();
        }
        this.filterScreen.setFiltersForProvider(this.provider, this.filterPairs);
    }

    public void removeWidget(GeneralFilterWidget filterWidget) {
        this.widgets.remove((Object)filterWidget);
        this.scrollOffset = 0;
        this.updateQuery();
        this.createWidgets();
    }

    public ItemStatProvider<?> getProvider() {
        return this.provider;
    }

    private boolean isScrollable() {
        if (this.anyFilterActive()) {
            return false;
        }
        if (this.provider.getValidInputs().isEmpty()) {
            return this.widgets.size() > 5;
        }
        return this.provider.getValidInputs().size() > 6;
    }

    private float getScrollableArea() {
        if (this.provider.getValidInputs().isEmpty() && !this.anyFilterActive()) {
            return 90.0f;
        }
        return 112.0f;
    }

    private int getMaxScrollOffset() {
        if (this.provider.getValidInputs().isEmpty() && !this.anyFilterActive()) {
            return (this.widgets.size() - 5) * 24;
        }
        return (this.provider.getValidInputs().size() - 6) * 24;
    }

    private float getScrollbarHeight() {
        if (this.provider.getValidInputs().isEmpty() && !this.anyFilterActive()) {
            return 120.0f;
        }
        return 144.0f;
    }

    private boolean anyFilterActive() {
        return !this.widgets.isEmpty() && this.widgets.getFirst() instanceof AnyFilterWidget;
    }

    private void cycleNumericChoice(int direction) {
        ArrayList<NumericType> types = new ArrayList<NumericType>(List.of(NumericType.values()));
        this.numericChoice = types.indexOf((Object)this.numericChoice) + direction < 0 ? (NumericType)((Object)types.getLast()) : (types.indexOf((Object)this.numericChoice) + direction == types.size() ? (NumericType)((Object)types.getFirst()) : (NumericType)((Object)types.get(types.indexOf((Object)this.numericChoice) + direction)));
        this.numericChoiceButton.setMessage((Component)Component.literal((String)EnumUtils.toNiceString(this.numericChoice)));
    }

    private void renderScrollBar(PoseStack poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, this.getX() + 184, this.getY(), 0.0f, 6.0f, this.getScrollbarHeight());
        this.scrollRenderY = (int)((float)this.getY() + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, this.getScrollbarHeight() - 20.0f));
        RenderUtils.drawRect(poseStack, this.draggingScroll ? CommonColors.BLACK : CommonColors.GRAY, this.getX() + 184, this.scrollRenderY, 0.0f, 6.0f, 20.0f);
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
        for (GeneralFilterWidget filterWidget : this.widgets) {
            int newY = this.getY() + 2 + this.widgets.indexOf((Object)filterWidget) * 24 - this.scrollOffset;
            filterWidget.updateY(newY);
            filterWidget.visible = newY >= this.getY() + 2 - 24 && (float)newY <= (float)(this.getY() + 2) + this.getScrollbarHeight();
        }
    }

    private GeneralFilterWidget getNumericFilterWidget(int renderY) {
        return switch (this.numericChoice.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NumericFilterWidgetFactory.createSingleWidget(this.provider.getType(), this.getX() + 5, renderY, 175, 20, null, this, this.filterScreen);
            case 1 -> NumericFilterWidgetFactory.createRangedWidget(this.provider.getType(), this.getX() + 5, renderY, 175, 20, null, this, this.filterScreen);
            case 2 -> NumericFilterWidgetFactory.createInequalityWidget(this.provider.getType(), this.getX() + 5, renderY, 175, 20, null, this, this.filterScreen);
        };
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private static enum NumericType {
        SINGLE,
        RANGED,
        INEQUALITY;

    }
}

