/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.filters.StringStatFilter;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public final class SelectionFilterWidget
extends GeneralFilterWidget {
    private static final CustomColor UNUSED_COLOR = new CustomColor(116, 0, 0, 255);
    private static final CustomColor UNUSED_COLOR_BORDER = new CustomColor(220, 0, 0, 255);
    private static final CustomColor USED_COLOR = new CustomColor(0, 116, 0, 255);
    private static final CustomColor USED_COLOR_BORDER = new CustomColor(0, 220, 0, 255);
    private final String valueName;
    private final WynntilsCheckbox usedCheckbox;
    private boolean used;

    public SelectionFilterWidget(int x, int y, int width, int height, String valueName, Optional<StatProviderAndFilterPair> filterPair, ProviderFilterListWidget parent) {
        super(x, y, width, height, (Component)Component.literal((String)"Selection Filter Widget"), parent);
        this.valueName = valueName;
        this.used = filterPair.isPresent();
        this.usedCheckbox = new WynntilsCheckbox(x + width - 16, y + 2, 16, (Component)Component.literal((String)""), this.used, 0, (c, b) -> this.toggleUsed());
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, this.getRectColor().withAlpha(100), this.getX(), this.getY(), 0.0f, this.width - 18, this.height);
        RenderUtils.drawRectBorders(poseStack, this.getBorderColor(), this.getX(), this.getY(), this.getX() + this.width - 18, this.getY() + this.height, 1.0f, 2.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.valueName), this.getX() + 2, (float)this.getY() + (float)this.height / 2.0f, this.width - 4, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        this.usedCheckbox.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.usedCheckbox.isMouseOver(mouseX, mouseY)) {
            return this.usedCheckbox.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.setY(y);
        this.usedCheckbox.setY(y + 2);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (!this.used) {
            return null;
        }
        Optional<StringStatFilter> statFilterOpt = new StringStatFilter.StringStatFilterFactory().create(this.valueName);
        return statFilterOpt.map(stringStatFilter -> new StatProviderAndFilterPair<String>(this.parent.getProvider(), (StatFilter<String>)stringStatFilter)).orElse(null);
    }

    private void toggleUsed() {
        this.used = !this.used;
        this.parent.updateQuery();
    }

    private CustomColor getRectColor() {
        return this.used ? USED_COLOR : UNUSED_COLOR;
    }

    private CustomColor getBorderColor() {
        return this.used ? USED_COLOR_BORDER : UNUSED_COLOR_BORDER;
    }
}

