/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.numeric.InequalityNumericFilterWidget;
import com.wynntils.services.itemfilter.filters.RangedStatFilters;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import java.util.Optional;

public class InequalityIntegerFilterWidget
extends InequalityNumericFilterWidget<Integer> {
    public InequalityIntegerFilterWidget(int x, int y, int width, int height, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, parent, filterScreen);
        StatFilter statFilter;
        if (filterPair != null && (statFilter = filterPair.statFilter()) instanceof RangedStatFilters.RangedIntegerStatFilter) {
            RangedStatFilters.RangedIntegerStatFilter integerStatFilter = (RangedStatFilters.RangedIntegerStatFilter)statFilter;
            if (integerStatFilter.getMin() != Integer.MIN_VALUE && integerStatFilter.getMax() == Integer.MAX_VALUE) {
                if (integerStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(integerStatFilter.getMin()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.GREATER_THAN);
                    this.setEntryInput(String.valueOf(integerStatFilter.getMin() - 1));
                }
            } else if (integerStatFilter.getMax() != Integer.MAX_VALUE && integerStatFilter.getMin() == Integer.MIN_VALUE) {
                if (integerStatFilter.isEqualsInString()) {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN_EQUAL);
                    this.setEntryInput(String.valueOf(integerStatFilter.getMax()));
                } else {
                    this.setInequalityType(InequalityNumericFilterWidget.InequalityType.LESS_THAN);
                    this.setEntryInput(String.valueOf(integerStatFilter.getMax() + 1));
                }
            }
        }
    }

    @Override
    protected Optional<StatFilter<Integer>> getInequalityStatFilter(String value, InequalityNumericFilterWidget.InequalityType inequalityType) {
        return new RangedStatFilters.RangedIntegerStatFilter.RangedIntegerStatFilterFactory().create(inequalityType.getMessage() + value).map(f -> f);
    }
}

