/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets.numeric;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public abstract class RangedNumericFilterWidget<T>
extends GeneralFilterWidget {
    private final Button removeButton;
    private final TextInputBoxWidget minInput;
    private final TextInputBoxWidget maxInput;
    private boolean ignoreUpdate = false;

    protected RangedNumericFilterWidget(int x, int y, int width, int height, ProviderFilterListWidget parent, ItemFilterScreen filterScreen) {
        super(x, y, width, height, (Component)Component.literal((String)"Ranged Numeric Filter Widget"), parent);
        this.minInput = new TextInputBoxWidget(this.getX(), this.getY(), 50, this.getHeight(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        this.maxInput = new TextInputBoxWidget(this.getX() + 67, this.getY(), 50, this.getHeight(), s -> {
            if (this.ignoreUpdate) {
                return;
            }
            parent.updateQuery();
        }, filterScreen);
        this.removeButton = new Button.Builder((Component)Component.literal((String)"\ud83d\uddd1"), button -> parent.removeWidget(this)).pos(this.getX() + width - 20, this.getY()).size(20, 20).build();
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.minInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.maxInput.render(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.render(guiGraphics, mouseX, mouseY, partialTick);
        FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromString("-"), this.getX() + 59, this.getY() + 11, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minInput.isMouseOver(mouseX, mouseY)) {
            return this.minInput.mouseClicked(mouseX, mouseY, button);
        }
        if (this.maxInput.isMouseOver(mouseX, mouseY)) {
            return this.maxInput.mouseClicked(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.minInput.isMouseOver(mouseX, mouseY)) {
            return this.minInput.mouseReleased(mouseX, mouseY, button);
        }
        if (this.maxInput.isMouseOver(mouseX, mouseY)) {
            return this.maxInput.mouseReleased(mouseX, mouseY, button);
        }
        if (this.removeButton.isMouseOver(mouseX, mouseY)) {
            return this.removeButton.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
        this.setY(y);
        this.minInput.setY(y);
        this.maxInput.setY(y);
        this.removeButton.setY(y);
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.minInput.getTextBoxInput().isEmpty() || this.maxInput.getTextBoxInput().isEmpty()) {
            return null;
        }
        String min = this.minInput.getTextBoxInput();
        String max = this.maxInput.getTextBoxInput();
        Optional<StatFilter<StatFilter>> rangedStatFilterOpt = this.getRangedStatFilter(min, max);
        return rangedStatFilterOpt.map(statFilter -> new StatProviderAndFilterPair(this.parent.getProvider(), statFilter)).orElse(null);
    }

    protected void setMinInput(String input) {
        this.ignoreUpdate = true;
        this.minInput.setTextBoxInput(input);
        this.ignoreUpdate = false;
    }

    protected void setMaxInput(String input) {
        this.ignoreUpdate = true;
        this.maxInput.setTextBoxInput(input);
        this.ignoreUpdate = false;
    }

    protected abstract Optional<StatFilter<T>> getRangedStatFilter(String var1, String var2);
}

