/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.loading;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public final class LoadingScreen
extends WynntilsScreen {
    private static final String LOGO_STRING = "\ue005\udaff\udfff\ue006";
    private static final String TEXT_LOGO_STRING = "Wynncraft";
    private static final ResourceLocation LOGO_FONT_LOCATION = ResourceLocation.withDefaultNamespace((String)"screen/static");
    private static final CustomColor MOSS_GREEN = CustomColor.fromInt(5403945).withAlpha(255);
    private static final int SPINNER_SPEED = 1200;
    private final Runnable onClose;
    private int offsetX;
    private int offsetY;
    private String message = "";
    private String stageTitle = "";
    private String subtitle = "";

    private LoadingScreen(Runnable onClose) {
        super((Component)Component.translatable((String)"screens.wynntils.characterSelection.name"));
        this.onClose = onClose;
    }

    public static LoadingScreen create(Runnable onClose) {
        return new LoadingScreen(onClose);
    }

    public void onClose() {
        ClientPacketListener connection = McUtils.mc().getConnection();
        if (connection != null) {
            connection.close();
        }
        this.onClose.run();
        super.onClose();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStageTitle(String stageTitle) {
        this.stageTitle = stageTitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    @Override
    public void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.width - Texture.SCROLL_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.height - Texture.SCROLL_BACKGROUND.height()) / 2.0f);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        int textureWidth = Texture.BACKGROUND_SPLASH.width();
        int textureHeight = Texture.BACKGROUND_SPLASH.height();
        float widthScaleFactor = (float)this.width / (float)textureWidth;
        float heightScaleFactor = (float)this.height / (float)textureHeight;
        float scaleFactor = Math.max(widthScaleFactor, heightScaleFactor);
        float scaledWidth = (float)textureWidth * scaleFactor;
        float scaledHeight = (float)textureHeight * scaleFactor;
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.BACKGROUND_SPLASH.resource(), ((float)this.width - scaledWidth) / 2.0f, ((float)this.height - scaledHeight) / 2.0f, 0.0f, scaledWidth, scaledHeight, textureWidth, textureHeight);
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BACKGROUND, this.offsetX, this.offsetY);
        int centerX = (int)((float)Texture.SCROLL_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX);
        MutableComponent logoComponent = Services.ResourcePack.isPreloadedPackSelected() ? Component.literal((String)LOGO_STRING).withStyle(Style.EMPTY.withFont(LOGO_FONT_LOCATION)) : Component.literal((String)TEXT_LOGO_STRING);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)logoComponent), centerX, 60 + this.offsetY, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.message), centerX, 100 + this.offsetY, MOSS_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.stageTitle), centerX, 120 + this.offsetY, MOSS_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.subtitle), centerX, 130 + this.offsetY, MOSS_GREEN, HorizontalAlignment.CENTER, VerticalAlignment.TOP, TextShadow.NONE);
        boolean state = System.currentTimeMillis() % 1200L < 600L;
        this.drawSpinner(poseStack, centerX, 150 + this.offsetY, state);
    }

    private void drawSpinner(PoseStack poseStack, float x, float y, boolean state) {
        ResourceLocation resource = Texture.RELOAD_ICON_OFFSET.resource();
        int fullWidth = Texture.RELOAD_ICON_OFFSET.width();
        int spinnerWidth = fullWidth / 2;
        int spinnerHeight = Texture.RELOAD_ICON_OFFSET.height();
        int uOffset = state ? spinnerWidth : 0;
        RenderUtils.drawTexturedRect(poseStack, resource, x - (float)spinnerWidth / 2.0f, y, 0.0f, spinnerWidth, spinnerHeight, uOffset, 0, spinnerWidth, spinnerHeight, fullWidth, spinnerHeight);
    }
}

