/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.lootrunpaths;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsListScreen;
import com.wynntils.screens.base.widgets.BackButton;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.base.widgets.ReloadButton;
import com.wynntils.screens.lootrunpaths.widgets.LootrunPathButton;
import com.wynntils.screens.wynntilsmenu.WynntilsMenuScreen;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.event.LootrunPathCacheRefreshEvent;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.TaskUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

public final class WynntilsLootrunPathsScreen
extends WynntilsListScreen<LootrunPathInstance, LootrunPathButton> {
    private WynntilsLootrunPathsScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.lootruns.name"));
        WynntilsMod.registerEventListener(this);
    }

    public static Screen create() {
        return new WynntilsLootrunPathsScreen();
    }

    public void onClose() {
        WynntilsMod.unregisterEventListener(this);
        super.onClose();
    }

    @SubscribeEvent
    public void onLootrunCacheRefresh(LootrunPathCacheRefreshEvent event) {
        this.reloadElements();
    }

    @Override
    protected void doInit() {
        super.doInit();
        TaskUtils.runAsync(Services.LootrunPaths::refreshLootrunCache);
        this.addRenderableWidget((GuiEventListener)new BackButton((int)(((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 16.0f) / 2.0f + (float)this.offsetX), 65 + this.offsetY, Texture.BACK_ARROW_OFFSET.width() / 2, Texture.BACK_ARROW_OFFSET.height(), WynntilsMenuScreen.create()));
        this.addRenderableWidget((GuiEventListener)new ReloadButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 21 + this.offsetX, 11 + this.offsetY, (int)((float)Texture.RELOAD_ICON_OFFSET.width() / 2.0f / 1.7f), (int)((float)Texture.RELOAD_ICON_OFFSET.height() / 1.7f), "lootrun", () -> TaskUtils.runAsync(Services.LootrunPaths::refreshLootrunCache)));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.addRenderableWidget((GuiEventListener)new PageSelectorButton(Texture.CONTENT_BOOK_BACKGROUND.width() - 50 + this.offsetX, Texture.CONTENT_BOOK_BACKGROUND.height() - 25 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Renderable renderable = this.hovered;
        if (renderable instanceof LootrunPathButton) {
            LootrunPathButton lootrunPathButton = (LootrunPathButton)renderable;
            LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
            List<MutableComponent> tooltipLines = currentLootrun != null && Objects.equals(lootrunPathButton.getLootrun().name(), currentLootrun.name()) ? List.of(Component.literal((String)lootrunPathButton.getLootrun().name()).withStyle(ChatFormatting.BOLD), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.loaded").withStyle(ChatFormatting.YELLOW), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.viewInFolder").withStyle(ChatFormatting.GOLD), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.openOnMap").withStyle(ChatFormatting.BLUE), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.unload").withStyle(ChatFormatting.GREEN)) : List.of(Component.literal((String)lootrunPathButton.getLootrun().name()).withStyle(ChatFormatting.BOLD), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.load").withStyle(ChatFormatting.GREEN), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.viewInFolder").withStyle(ChatFormatting.GOLD), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.openOnMap").withStyle(ChatFormatting.BLUE), Component.translatable((String)"screens.wynntils.lootruns.lootrunButton.remove").withStyle(ChatFormatting.RED));
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipLines, mouseX, mouseY);
            return;
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, I18n.get((String)"screens.wynntils.lootruns.name", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        if (this.elements.isEmpty()) {
            this.renderNoElementsHelper(poseStack, I18n.get((String)"screens.wynntils.lootruns.noLootruns", (Object[])new Object[0]));
        }
        this.renderDescription(poseStack);
        this.renderPageInfo(poseStack, this.currentPage + 1, this.maxPage + 1);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderDescription(PoseStack poseStack) {
        LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
        if (currentLootrun != null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(currentLootrun.name()), (float)(20 + this.offsetX), (float)(80 + this.offsetY), CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.4f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.lootruns.chests", (Object[])new Object[0]) + ": " + currentLootrun.chests().size()), 20 + this.offsetX, 99 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.lootruns.notes", (Object[])new Object[0]) + ": " + currentLootrun.notes().size()), 20 + this.offsetX, 109 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            Position start = (Position)currentLootrun.path().points().getFirst();
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.lootruns.start", (Object[])new Object[0]) + ": " + String.format("[%d, %d, %d]", (int)start.x(), (int)start.y(), (int)start.z())), 20 + this.offsetX, 119 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
            Position end = (Position)currentLootrun.path().points().getLast();
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.lootruns.end", (Object[])new Object[0]) + ": " + String.format("[%d, %d, %d]", (int)end.x(), (int)end.y(), (int)end.z())), 20 + this.offsetX, 129 + this.offsetY, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE);
        } else {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.lootruns.description1", (Object[])new Object[0])), (float)(20 + this.offsetX), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 10.0f + (float)this.offsetX, (float)(80 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, TextShadow.NONE);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.lootruns.description2", (Object[])new Object[0])), (float)(20 + this.offsetX), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 10.0f + (float)this.offsetX, (float)(155 + this.offsetY), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 30.0f, CommonColors.BLACK, HorizontalAlignment.LEFT, TextShadow.NONE);
        }
    }

    @Override
    protected LootrunPathButton getButtonFromElement(int i) {
        int offset = i % this.getElementsPerPage();
        return new LootrunPathButton((int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 15.0f + (float)this.offsetX), offset * 13 + 25 + this.offsetY, Texture.CONTENT_BOOK_BACKGROUND.width() / 2 - 37, 9, (LootrunPathInstance)this.elements.get(i), this);
    }

    @Override
    protected void reloadElementsList(String searchTerm) {
        this.elements.addAll(Services.LootrunPaths.getLootruns().stream().filter(lootrunInstance -> StringUtils.partialMatch(lootrunInstance.name(), searchTerm)).toList());
    }
}

