/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.playerviewer.widgets;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.screens.playerviewer.widgets.PlayerInteractionButton;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.network.chat.Component;

public class FriendButton
extends PlayerInteractionButton {
    private final String playerName;

    public FriendButton(int x, int y, String playerName) {
        super(x, y);
        this.playerName = playerName;
        this.updateIcon();
    }

    @Override
    public void onPress() {
        super.onPress();
        Handlers.Command.queueCommand("friend " + (Models.Friends.isFriend(this.playerName) ? "remove " : "add ") + this.playerName);
    }

    public void updateIcon() {
        boolean isFriend = Models.Friends.isFriend(this.playerName);
        this.icon = isFriend ? Texture.FRIEND_REMOVE_ICON : Texture.FRIEND_ADD_ICON;
        this.tooltipText = List.of(Component.translatable((String)("screens.wynntils.playerViewer." + (isFriend ? "removeFriend" : "addFriend"))));
    }
}

