/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.wynntils.core.persisted.config.Config;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.screens.settings.widgets.GeneralSettingsButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BooleanSettingsButton
extends GeneralSettingsButton {
    private final Config<Boolean> config;

    public BooleanSettingsButton(int x, int y, Config<Boolean> config, int maskTopY, int maskBottomY) {
        super(x, y, 90, 20, (Component)BooleanSettingsButton.getTitle(config), ComponentUtils.wrapTooltips(List.of(Component.literal((String)config.getDescription())), 150), maskTopY, maskBottomY);
        this.config = config;
    }

    public void onPress() {
        this.config.setValue(!BooleanSettingsButton.isEnabled(this.config));
        this.setMessage((Component)BooleanSettingsButton.getTitle(this.config));
        Screen screen = McUtils.screen();
        if (screen instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)screen;
            bookSettingsScreen.populateConfigurables();
        }
    }

    private static MutableComponent getTitle(Config<Boolean> config) {
        return BooleanSettingsButton.isEnabled(config) ? Component.translatable((String)"screens.wynntils.settingsScreen.booleanConfig.enabled") : Component.translatable((String)"screens.wynntils.settingsScreen.booleanConfig.disabled");
    }

    @Override
    protected CustomColor getTextColor() {
        return BooleanSettingsButton.isEnabled(this.config) ? CommonColors.GREEN : CommonColors.RED;
    }

    private static boolean isEnabled(Config<Boolean> config) {
        return (Boolean)config.get();
    }
}

