/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.screens.settings.widgets.BooleanSettingsButton;
import com.wynntils.screens.settings.widgets.CustomColorSettingsButton;
import com.wynntils.screens.settings.widgets.EnumSettingsButton;
import com.wynntils.screens.settings.widgets.GeneralSettingsButton;
import com.wynntils.screens.settings.widgets.OverlaySettingsWidget;
import com.wynntils.screens.settings.widgets.ResetButton;
import com.wynntils.screens.settings.widgets.TextInputBoxSettingsWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigTile
extends WynntilsButton {
    private final Screen screen;
    private final int maskTopY;
    private final int maskBottomY;
    private final GeneralSettingsButton resetButton;
    private final StyledText displayName;
    private final Overlay overlay;
    private AbstractWidget configOptionElement;

    public ConfigTile(int x, int y, int width, int height, Screen screen, Config<?> config, Overlay overlay) {
        super(x, y, width, height, (Component)Component.literal((String)config.getJsonName()));
        this.screen = screen;
        if (screen instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen settingsScreen = (WynntilsBookSettingsScreen)screen;
            this.maskTopY = settingsScreen.getMaskTopY();
            this.maskBottomY = settingsScreen.getConfigMaskBottomY();
            this.displayName = settingsScreen.configOptionContains(config) ? StyledText.fromString(String.valueOf(ChatFormatting.UNDERLINE) + config.getDisplayName()) : StyledText.fromString(config.getDisplayName());
        } else if (screen instanceof OverlaySelectionScreen) {
            OverlaySelectionScreen overlaySelectionScreen = (OverlaySelectionScreen)screen;
            this.maskTopY = overlaySelectionScreen.getConfigMaskTopY();
            this.maskBottomY = overlaySelectionScreen.getConfigMaskBottomY();
            this.displayName = overlaySelectionScreen.configOptionContains(config) ? StyledText.fromString(String.valueOf(ChatFormatting.UNDERLINE) + config.getDisplayName()) : StyledText.fromString(config.getDisplayName());
        } else {
            this.maskTopY = 0;
            this.maskBottomY = McUtils.screen().height;
            this.displayName = StyledText.fromString(config.getDisplayName());
        }
        this.overlay = overlay;
        this.configOptionElement = this.getWidgetFromConfig(config);
        this.resetButton = new ResetButton(config, () -> {
            this.configOptionElement = this.getWidgetFromConfig(config);
        }, x + width - 40, this.getRenderY(), this.maskTopY, this.maskBottomY);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.resetButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderDisplayName(poseStack);
        RenderUtils.drawLine(poseStack, CommonColors.GRAY, this.getX(), this.getY() + this.height, this.getX() + this.width, this.getY() + this.height, 0.0f, 1.0f);
        this.configOptionElement.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderDisplayName(PoseStack poseStack) {
        FontRenderer.getInstance().renderScrollingText(poseStack, this.displayName, this.getRenderX(), this.getY() + 3, this.width - 3, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 0.8f);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        Screen screen = McUtils.screen();
        if (screen instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)screen;
            bookSettingsScreen.changesMade();
        }
        return this.resetButton.mouseClicked(mouseX, mouseY, button) || this.configOptionElement.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        return this.configOptionElement.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.maskTopY || mouseY >= (double)this.maskBottomY) {
            return false;
        }
        return this.configOptionElement.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
    }

    public void setY(int y) {
        super.setY(y);
        this.configOptionElement.setY(this.getRenderY());
        this.resetButton.setY(this.getRenderY());
    }

    public void onPress() {
    }

    private int getRenderY() {
        return this.getY() + 19;
    }

    private int getRenderX() {
        return this.getX() + 3;
    }

    private <E extends Enum<E>> AbstractWidget getWidgetFromConfig(Config<?> configOption) {
        if (this.overlay != null && this.screen != null && (configOption.getType().equals(OverlayPosition.class) || configOption.getType().equals(OverlaySize.class) || configOption.getType().equals(HorizontalAlignment.class) || configOption.getType().equals(VerticalAlignment.class))) {
            return new OverlaySettingsWidget(this.getRenderX(), this.getRenderY(), configOption, this.screen, this.maskTopY, this.maskBottomY, this.overlay);
        }
        if (configOption.getType().equals(Boolean.class)) {
            return new BooleanSettingsButton(this.getRenderX(), this.getRenderY(), configOption, this.maskTopY, this.maskBottomY);
        }
        if (configOption.isEnum()) {
            return new EnumSettingsButton<Boolean>(this.getRenderX(), this.getRenderY(), configOption, this.maskTopY, this.maskBottomY);
        }
        if (configOption.getType().equals(CustomColor.class)) {
            return new CustomColorSettingsButton(this.getRenderX(), this.getRenderY(), (Config<CustomColor>)configOption, (TextboxScreen)this.screen, this.maskTopY, this.maskBottomY);
        }
        return new TextInputBoxSettingsWidget<Boolean>(this.getRenderX(), this.getRenderY(), configOption, (TextboxScreen)this.screen, this.maskTopY, this.maskBottomY);
    }
}

