/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public abstract class GeneralSettingsTabButton
extends BasicTexturedButton {
    private static final int MAX_OFFSET = -8;
    private static final int MIN_OFFSET = 0;
    protected boolean selectedTab = false;
    protected Texture tagTexture;
    private final OffsetDirection offsetDirection;
    private final Texture iconTexture;
    private final int offsetX;
    private final int offsetY;
    private int hoverOffset = 0;

    GeneralSettingsTabButton(int x, int y, int width, int height, Consumer<Integer> onClick, List<Component> tooltip, Texture tagTexture, Texture iconTexture, OffsetDirection offsetDirection, int offsetX, int offsetY) {
        super(x, y, width, height, tagTexture, onClick, tooltip);
        this.tagTexture = tagTexture;
        this.iconTexture = iconTexture;
        this.offsetDirection = offsetDirection;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        if (this.isHovered && (this.offsetDirection == OffsetDirection.UP && mouseY >= this.offsetY || this.offsetDirection == OffsetDirection.RIGHT && mouseX <= this.offsetX + Texture.CONFIG_BOOK_BACKGROUND.width() || this.offsetDirection == OffsetDirection.DOWN && mouseY <= this.offsetY + Texture.CONFIG_BOOK_BACKGROUND.height() || this.offsetDirection == OffsetDirection.LEFT && mouseX >= this.offsetX)) {
            this.isHovered = false;
        }
        if (this.selectedTab) {
            this.hoverOffset = this.offsetDirection == OffsetDirection.UP || this.offsetDirection == OffsetDirection.LEFT ? -8 : 8;
        } else if (this.isHovered) {
            this.hoverOffset += this.offsetDirection == OffsetDirection.UP || this.offsetDirection == OffsetDirection.LEFT ? -1 : 1;
            this.hoverOffset = this.offsetDirection == OffsetDirection.UP || this.offsetDirection == OffsetDirection.LEFT ? Math.max(this.hoverOffset, -8) : Math.min(this.hoverOffset, 8);
        } else {
            this.hoverOffset += this.offsetDirection == OffsetDirection.UP || this.offsetDirection == OffsetDirection.LEFT ? 1 : -1;
            this.hoverOffset = this.offsetDirection == OffsetDirection.UP || this.offsetDirection == OffsetDirection.LEFT ? Math.min(this.hoverOffset, 0) : Math.max(this.hoverOffset, 0);
        }
        int xOffset = 0;
        int yOffset = 0;
        if (this.offsetDirection == OffsetDirection.RIGHT || this.offsetDirection == OffsetDirection.LEFT) {
            xOffset = this.hoverOffset;
        } else {
            yOffset = this.hoverOffset;
        }
        RenderUtils.drawTexturedRect(poseStack, this.tagTexture, this.getX() + xOffset, this.getY() + yOffset);
        if (this.offsetDirection == OffsetDirection.UP || this.offsetDirection == OffsetDirection.DOWN) {
            RenderUtils.drawTexturedRect(poseStack, this.iconTexture, (float)this.getX() + (float)(this.getWidth() - this.iconTexture.width()) / 2.0f + (float)xOffset, this.getY() + 14 + yOffset);
        } else {
            RenderUtils.drawTexturedRect(poseStack, this.iconTexture, this.getX() + 14 + xOffset, (float)this.getY() + (float)(this.getHeight() - this.iconTexture.height()) / 2.0f + (float)yOffset);
        }
    }

    protected static enum OffsetDirection {
        UP,
        RIGHT,
        DOWN,
        LEFT;

    }
}

