/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.skillpointloadouts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.character.type.SavableSkillPointSet;
import com.wynntils.models.elements.type.Skill;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.skillpointloadouts.widgets.ConvertButton;
import com.wynntils.screens.skillpointloadouts.widgets.DeleteButton;
import com.wynntils.screens.skillpointloadouts.widgets.LoadButton;
import com.wynntils.screens.skillpointloadouts.widgets.LoadoutWidget;
import com.wynntils.screens.skillpointloadouts.widgets.SaveButton;
import com.wynntils.screens.skillpointloadouts.widgets.ScrollBar;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public final class SkillPointLoadoutsScreen
extends WynntilsGridLayoutScreen {
    private static final int MAX_LOADOUTS_PER_PAGE = 11;
    private List<LoadoutWidget> loadoutWidgets = new ArrayList<LoadoutWidget>();
    private boolean firstInit = true;
    private final List<Pair<Supplier<String>, Function<Skill, Integer>>> summaryParts = new ArrayList<Pair<Supplier<String>, Function<Skill, Integer>>>();
    private SaveButton saveAssignedButton;
    private SaveButton saveBuildButton;
    public TextInputBoxWidget saveNameInput;
    public boolean hasSaveNameConflict = false;
    public Pair<String, SavableSkillPointSet> selectedLoadout;
    private WynntilsButton loadButton;
    private WynntilsButton deleteButton;
    private WynntilsButton convertButton;
    private ScrollBar scrollBar;
    private float scrollPercent = 0.0f;

    private SkillPointLoadoutsScreen() {
        super((Component)Component.literal((String)"Skill Point Loadouts Screen"));
    }

    public static Screen create() {
        return new SkillPointLoadoutsScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        if (this.firstInit) {
            this.firstInit = false;
            this.summaryParts.add(Pair.of(() -> String.valueOf(Models.SkillPoint.hasIllegalAssigned() ? ChatFormatting.RED : "") + I18n.get((String)"screens.wynntils.skillPointLoadouts.assigned", (Object[])new Object[]{Models.SkillPoint.getAssignedSum()}), Models.SkillPoint::getAssignedSkillPoints));
            this.summaryParts.add(Pair.of(() -> I18n.get((String)"screens.wynntils.skillPointLoadouts.gear", (Object[])new Object[]{Models.SkillPoint.getGearSum()}), Models.SkillPoint::getGearSkillPoints));
            this.summaryParts.add(Pair.of(() -> I18n.get((String)"screens.wynntils.skillPointLoadouts.setBonus", (Object[])new Object[]{Models.SkillPoint.getSetBonusSum()}), Models.SkillPoint::getSetBonusSkillPoints));
            this.summaryParts.add(Pair.of(() -> I18n.get((String)"screens.wynntils.skillPointLoadouts.tomes", (Object[])new Object[]{Models.SkillPoint.getTomeSum()}), Models.SkillPoint::getTomeSkillPoints));
            this.summaryParts.add(Pair.of(() -> I18n.get((String)"screens.wynntils.skillPointLoadouts.crafted", (Object[])new Object[]{Models.SkillPoint.getCraftedSum()}), Models.SkillPoint::getCraftedSkillPoints));
            this.summaryParts.add(Pair.of(() -> I18n.get((String)"screens.wynntils.skillPointLoadouts.statusEffects", (Object[])new Object[]{Models.SkillPoint.getStatusEffectsSum()}), Models.SkillPoint::getStatusEffectSkillPoints));
            this.summaryParts.add(Pair.of(() -> I18n.get((String)"screens.wynntils.skillPointLoadouts.total", (Object[])new Object[]{Models.SkillPoint.getTotalSum()}), Models.SkillPoint::getTotalSkillPoints));
            Models.SkillPoint.populateSkillPoints();
        }
        this.populateLoadouts();
        this.saveNameInput = new TextInputBoxWidget((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 24.0f), (int)(this.dividedWidth * 48.0f - this.dividedWidth * 35.0f), 20, x -> {
            this.saveAssignedButton.active = !x.isBlank();
            this.saveBuildButton.active = !x.isBlank();
            this.hasSaveNameConflict = false;
            this.resetSaveButtons();
        }, this, this.saveNameInput);
        this.addRenderableWidget((GuiEventListener)this.saveNameInput);
        this.saveAssignedButton = new SaveButton((int)(this.dividedWidth * 49.0f), (int)(this.dividedHeight * 24.0f), (int)(this.dividedWidth * 53.0f - this.dividedWidth * 49.0f), 20, (Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.save"), this, Models.SkillPoint::saveCurrentSkillPoints);
        this.addRenderableWidget((GuiEventListener)this.saveAssignedButton);
        this.saveBuildButton = new SaveButton((int)(this.dividedWidth * 54.0f), (int)(this.dividedHeight * 24.0f), (int)(this.dividedWidth * 59.0f - this.dividedWidth * 54.0f), 20, (Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.saveBuild"), this, Models.SkillPoint::saveCurrentBuild);
        this.addRenderableWidget((GuiEventListener)this.saveBuildButton);
        this.loadButton = new LoadButton((int)(this.dividedWidth * 35.0f), (int)(this.dividedHeight * 52.0f), (int)(this.dividedWidth * 44.0f - this.dividedWidth * 35.0f), 20, (Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.load"), this);
        this.addRenderableWidget((GuiEventListener)this.loadButton);
        this.deleteButton = new DeleteButton((int)(this.dividedWidth * 45.0f), (int)(this.dividedHeight * 52.0f), (int)(this.dividedWidth * 51.0f - this.dividedWidth * 45.0f), 20, (Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.delete").withStyle(ChatFormatting.RED), this);
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        this.convertButton = new ConvertButton((int)(this.dividedWidth * 52.0f), (int)(this.dividedHeight * 52.0f), (int)(this.dividedWidth * 59.0f - this.dividedWidth * 52.0f), 20, (Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.convert"), this);
        this.addRenderableWidget((GuiEventListener)this.convertButton);
        this.scrollBar = new ScrollBar(this.dividedWidth * 30.0f, this.dividedHeight * 8.0f, this.dividedWidth * 0.5f, 0.0f, this, this.dividedHeight);
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.setSelectedLoadout(null);
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i;
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack poseStack = guiGraphics.pose();
        RenderUtils.drawRect(poseStack, CommonColors.WHITE, this.dividedWidth * 4.0f, this.dividedHeight * 8.0f, 0.0f, this.dividedWidth * 30.0f - this.dividedWidth * 4.0f, 1.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.skillPointLoadouts.loadoutName", (Object[])new Object[0])), this.dividedWidth * 4.0f, this.dividedHeight * 8.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        for (i = 0; i < 5; ++i) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.literal((String)Skill.values()[i].getSymbol()).withStyle(Style.EMPTY.withColor(Skill.values()[i].getColorCode()).withFont(ResourceLocation.withDefaultNamespace((String)"common")))), this.dividedWidth * (float)(21 + i * 2), this.dividedHeight * 8.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        }
        RenderUtils.drawRectBorders(poseStack, CommonColors.WHITE, this.dividedWidth * 34.0f, this.dividedHeight * 8.0f, this.dividedWidth * 60.0f, this.dividedHeight * 28.0f, 1.0f, 1.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.skillPointLoadouts.summary", (Object[])new Object[0])), this.dividedWidth * 34.0f, this.dividedHeight * 8.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        for (i = 0; i < 5; ++i) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.literal((String)Skill.values()[i].getSymbol()).withStyle(Style.EMPTY.withColor(Skill.values()[i].getColorCode()).withFont(ResourceLocation.withDefaultNamespace((String)"common")))), this.dividedWidth * (float)(51 + i * 2), this.dividedHeight * 8.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        }
        for (i = 0; i < this.summaryParts.size(); ++i) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.summaryParts.get(i).key().get()), this.dividedWidth * 35.0f, this.dividedHeight * (float)(10 + i * 2), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            for (int j = 0; j < 5; ++j) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(Skill.values()[j].getColorCode()) + String.valueOf(this.summaryParts.get(i).value().apply(Skill.values()[j]))), this.dividedWidth * (float)(51 + j * 2), this.dividedHeight * (float)(10 + i * 2), CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            }
        }
        if (this.hasSaveNameConflict) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.skillPointLoadouts.saveNameConflict", (Object[])new Object[0])), this.dividedWidth * 35.0f, this.dividedHeight * 23.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        if (this.selectedLoadout != null) {
            RenderUtils.drawRectBorders(poseStack, CommonColors.WHITE, this.dividedWidth * 34.0f, this.dividedHeight * 34.0f, this.dividedWidth * 60.0f, this.dividedHeight * 56.0f, 1.0f, 1.0f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.selectedLoadout.key()), this.dividedWidth * 34.0f, this.dividedHeight * 34.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            for (i = 0; i < 5; ++i) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((Component)Component.literal((String)Skill.values()[i].getSymbol()).withStyle(Style.EMPTY.withColor(Skill.values()[i].getColorCode()).withFont(ResourceLocation.withDefaultNamespace((String)"common")))), this.dividedWidth * (float)(51 + i * 2), this.dividedHeight * 34.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            }
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.skillPointLoadouts.assigned", (Object[])new Object[]{this.selectedLoadout.value().getSkillPointsSum()})), this.dividedWidth * 35.0f, this.dividedHeight * 37.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            for (i = 0; i < 5; ++i) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(Skill.values()[i].getColorCode()) + this.selectedLoadout.value().getSkillPointsAsArray()[i]), this.dividedWidth * (float)(51 + i * 2), this.dividedHeight * 37.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            }
            if (this.selectedLoadout.value().isBuild()) {
                int i2;
                int startingHeight = 41;
                if (this.selectedLoadout.value().weapon() != null) {
                    FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(this.selectedLoadout.value().weapon()), this.dividedWidth * 35.0f, this.dividedHeight * 40.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
                    startingHeight = 42;
                }
                ArrayList<TextRenderTask> tasks = new ArrayList<TextRenderTask>();
                for (i2 = 0; i2 < this.selectedLoadout.value().armourNames().size(); ++i2) {
                    String armour = this.selectedLoadout.value().armourNames().get(i2);
                    tasks.add(new TextRenderTask(StyledText.fromString(armour), new TextRenderSetting(this.dividedWidth * 9.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL)));
                    tasks.add(new TextRenderTask(StyledText.EMPTY, new TextRenderSetting(0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL)));
                }
                FontRenderer.getInstance().renderTexts(poseStack, this.dividedWidth * 35.0f, this.dividedHeight * (float)startingHeight, tasks);
                tasks = new ArrayList();
                for (i2 = 0; i2 < this.selectedLoadout.value().accessoryNames().size(); ++i2) {
                    String accessory = this.selectedLoadout.value().accessoryNames().get(i2);
                    tasks.add(new TextRenderTask(StyledText.fromString(accessory), new TextRenderSetting(this.dividedWidth * 9.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL)));
                    tasks.add(new TextRenderTask(StyledText.EMPTY, new TextRenderSetting(0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL)));
                }
                FontRenderer.getInstance().renderTexts(poseStack, this.dividedWidth * (float)(this.selectedLoadout.value().armourNames().isEmpty() ? 35 : 44), this.dividedHeight * (float)startingHeight, tasks);
            } else {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(I18n.get((String)"screens.wynntils.skillPointLoadouts.notBuild", (Object[])new Object[0])), this.dividedWidth * 35.0f, this.dividedHeight * 42.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            }
        }
        if (this.loadoutWidgets.size() > 11) {
            this.scrollBar.visible = true;
            this.scrollBar.active = true;
            float visibleRatio = Math.min(1.0f, 11.0f / (float)this.loadoutWidgets.size());
            float scrollbarLength = this.dividedHeight * 48.0f * visibleRatio + 1.0f;
            this.scrollBar.setY((int)(this.dividedHeight * 8.0f + this.dividedHeight * 48.0f * this.scrollPercent));
            this.scrollBar.setHeight((int)scrollbarLength);
        } else {
            this.scrollBar.visible = false;
            this.scrollBar.active = false;
        }
        RenderUtils.createRectMask(poseStack, (int)(this.dividedWidth * 4.0f) - 1, (int)(this.dividedHeight * 8.0f) + 1, (int)(this.dividedWidth * 26.0f) + 1, (int)(this.dividedHeight * 48.0f) + 1);
        this.loadoutWidgets.forEach(widget -> widget.render(guiGraphics, mouseX, mouseY, partialTick));
        RenderUtils.clearMask();
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        for (LoadoutWidget widget : this.loadoutWidgets) {
            if (!widget.isMouseOver(mouseX, mouseY)) continue;
            widget.mouseClicked(mouseX, mouseY, button);
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.loadoutWidgets.size() <= 11) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        this.doScroll(scrollY);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void doScroll(double scrollAmount) {
        int scrollableWidgets = Math.max(0, this.loadoutWidgets.size() - 11);
        if (scrollableWidgets == 0) {
            return;
        }
        float scrollableRatio = (float)scrollableWidgets / (float)this.loadoutWidgets.size();
        float maxScrollOffset = (float)(4 * (this.loadoutWidgets.size() - 1) - 43) / scrollableRatio;
        this.scrollPercent = (float)Math.max(0.0, Math.min((double)scrollableRatio, (double)this.scrollPercent - scrollAmount / 50.0));
        this.loadoutWidgets.forEach(widget -> {
            float baseYPosition = this.dividedHeight * (9.0f + (float)this.loadoutWidgets.indexOf(widget) * 4.0f);
            float scrollOffset = this.dividedHeight * maxScrollOffset * this.scrollPercent;
            widget.setY((int)(baseYPosition - scrollOffset));
            widget.visible = !((float)widget.getY() <= this.dividedHeight * 4.0f) && !((float)widget.getY() >= this.dividedHeight * 56.0f);
        });
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 261 && this.deleteButton.active) {
            this.deleteButton.onPress();
            return true;
        }
        if (keyCode == 269) {
            this.doScroll(Double.NEGATIVE_INFINITY);
        } else if (keyCode == 268) {
            this.doScroll(Double.POSITIVE_INFINITY);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setSelectedLoadout(Pair<String, SavableSkillPointSet> loadout) {
        if (loadout == null) {
            this.selectedLoadout = null;
            this.loadButton.active = false;
            this.loadButton.visible = false;
            this.deleteButton.active = false;
            this.deleteButton.visible = false;
            this.convertButton.active = false;
            this.convertButton.visible = false;
            return;
        }
        this.selectedLoadout = loadout;
        this.loadButton.active = true;
        this.loadButton.visible = true;
        this.deleteButton.active = true;
        this.deleteButton.visible = true;
        this.convertButton.active = true;
        this.convertButton.visible = true;
        if (this.selectedLoadout.value().getMinimumCombatLevel() > Models.CombatXp.getCombatLevel().current()) {
            this.loadButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"screens.wynntils.skillPointLoadouts.levelIncompatible").withStyle(ChatFormatting.RED)));
        }
    }

    public Pair<String, SavableSkillPointSet> getSelectedLoadout() {
        return this.selectedLoadout;
    }

    public void resetSaveButtons() {
        this.saveAssignedButton.reset();
        this.saveBuildButton.reset();
    }

    public void populateLoadouts() {
        this.loadoutWidgets = new ArrayList<LoadoutWidget>();
        Map<String, SavableSkillPointSet> loadouts = Models.SkillPoint.getLoadouts();
        for (Map.Entry<String, SavableSkillPointSet> entry : loadouts.entrySet()) {
            this.loadoutWidgets.add(new LoadoutWidget((int)(this.dividedWidth * 4.0f), (int)(this.dividedHeight * (float)(9 + this.loadoutWidgets.size() * 4)), (int)(this.dividedWidth * 26.0f), (int)(this.dividedHeight * 4.0f), this.dividedWidth, entry.getKey(), entry.getValue(), this));
        }
    }
}

