/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets;

import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class TerritoryApplyLoadoutButton
extends WynntilsButton
implements TooltipProvider {
    private static final int TOOLTIP_WIDTH = 200;
    private final Supplier<Texture> textureSupplier;
    private final Consumer<Integer> onClick;
    private final List<Component> tooltip;

    public TerritoryApplyLoadoutButton(int x, int y, int width, int height, Supplier<Texture> textureSupplier, Consumer<Integer> onClick, List<Component> tooltip) {
        super(x, y, width, height, (Component)Component.empty());
        this.textureSupplier = textureSupplier;
        this.onClick = onClick;
        this.tooltip = tooltip;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawTexturedRect(guiGraphics.pose(), this.textureSupplier.get(), this.getX(), this.getY());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        this.playDownSound(Minecraft.getInstance().getSoundManager());
        this.onClick.accept(button);
        return true;
    }

    @Override
    public List<Component> getTooltipLines() {
        return ComponentUtils.wrapTooltips(this.tooltip, 200);
    }

    public void onPress() {
    }
}

