/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.destination;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DestinationService
extends Service {
    private Map<String, String> destinations = new HashMap<String, String>();

    public DestinationService() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_DESTINATIONS).handleReader(this::handleDestinations);
    }

    public String getAbbreviation(String location) {
        this.destinations.computeIfAbsent(location, this::findNextAbbreviation);
        return this.destinations.get(location);
    }

    private String findNextAbbreviation(String location) {
        Object abbreviation = location.substring(0, 2);
        int i = 2;
        while (this.destinations.containsValue(abbreviation)) {
            while (location.charAt(i) == ' ') {
                if (i == location.length() - 1) {
                    WynntilsMod.warn("DestinationService: No unique destination found for " + location + ", computed fallback abbreviation " + (String)abbreviation);
                    return abbreviation;
                }
                ++i;
            }
            abbreviation = "" + location.charAt(0) + location.charAt(i);
            ++i;
        }
        WynntilsMod.warn("DestinationService: No destination found for " + location + ", computed fallback abbreviation " + (String)abbreviation);
        return abbreviation;
    }

    private void handleDestinations(Reader reader) {
        HashMap<String, String> newDestinations = new HashMap<String, String>();
        Destination result = (Destination)WynntilsMod.GSON.fromJson(reader, Destination.class);
        for (Destination.DestinationDetail destination : result.destinations) {
            newDestinations.put(destination.location, destination.abbreviation);
        }
        this.destinations = newDestinations;
    }

    private static class Destination {
        List<DestinationDetail> destinations;

        private Destination() {
        }

        private static class DestinationDetail {
            String location;
            String abbreviation;

            private DestinationDetail() {
            }
        }
    }
}

